<?php namespace App\Http\Controllers;
use App\Models\CabinCrew;
use App\Models\CaptainFirstOfficer;
use App\Models\ChangeLog;
use App\Models\Maintenance;
use App\Models\Position;
use App\Models\Relationship;
use App\Models\User;
use App\Models\UserDepartment;
use App\Models\UserFamily;
use App\Models\UserHistory;
use Illuminate\Support\Facades\Auth;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 14.01.15
 * Time: 10:52
 */

class ChangeRecordController extends Controller
{
    public function ajaxSaveRecords(){
        $data = request()->get('data');
        $date_format = request()->get('date_format');
        $table = request()->get('table');
        $user_id = request()->get('user_id');

        debug(request()->all());

        $parents = Relationship::whereIn('title', ['Mother', 'Father'])->pluck('id')->all();
        $activeRecordIDs = [0];
        if ($data) {
            foreach ($data as $record) {
                if (is_array($record) && count($record)) {
                    $value_before = null;

                    $search = UserFamily::where('user_id', $user_id);
                    // If parents 1 Record For Each
                    if (in_array($record['relationship_id'], $parents))
                        $search->where('relationship_id', $record['relationship_id']);
                    else
                        $search->where('dob', date('Y-m-d', strtotime($record['dob'])));

                    $search = $search->first(['id', 'is_nominee', 'first_name', 'last_name', 'dob']);

                    // Double Check by First/Last Names For All Members Except Parents
                    if (is_null($search) && !in_array($record['relationship_id'], $parents)) {
                        $search = UserFamily::where('user_id', $user_id)
                            ->where('first_name', $record['first_name'])
                            ->where('last_name', $record['last_name'])
                            ->first(['id', 'is_nominee', 'first_name', 'last_name', 'dob']);
                    }

                    if ($search) {
                        $value_before = $search->toArray();
                    } else {
                        $search = new UserFamily;
                        $search->user_id = $user_id;
                    }
                    foreach ($record as $property => $value) {
                        if (dateValidation($value, $date_format)) {
                            $value = date('Y-m-d', strtotime($value));
                        }
                        $search->$property = $value;

                    }

                    $search->save();

                    $value = $search->find($search->id, ['id', 'is_nominee', 'first_name', 'last_name', 'dob']);
                    $activeRecordIDs[] = $search->id;
                    ChangeLog::LogChangeArray($user_id, $table, $value_before, $value->toArray());
                }
            }
        }

        // Unset Nominee Status For Not Active User Family Members
        $records = UserFamily::where('user_id', $user_id)
                            ->whereNotIn('id', $activeRecordIDs)
                            ->get(['id', 'is_nominee', 'first_name', 'last_name', 'dob']);

        foreach ($records as $record) {
            $value_before = $record->toArray();
            $record->is_nominee = 0;
            $record->save();
            ChangeLog::LogChangeArray($user_id, $table, $value_before, $record->toArray());
        }

        return response()->json([
            'success'   => TRUE
        ]);

    }

    public function ajaxSaveChanges(){
        $type = request()->get('type');
        $crew_id = request()->get('crew_id');
        $item = request()->get('item');
        $table = request()->has('table') ? request()->get('table') : 'none';
        $value = request()->get('value');
        $date_format = request()->get('date_format');

        $date_format = (is_null($date_format) || $date_format == "not_applicable") ? 'dMy' : $date_format;

        if (!is_array($value) && dateValidation($value, $date_format)){
            $value =  date('Y-m-d', strtotime($value));
        }


        if ($table == 'users' || in_array($item, ['passport_doi', 'passport_dex'])){
            $user = User::find($crew_id);
            debug(request()->all());
            if ($user){
                $value = is_null($value) ? "" : $value;
                if (in_array($item, ['passport_doi', 'passport_dex'])) {
                    $passport =  !is_null($user->passport) ? unserialize($user->passport) : ['p_exp_date' => '', 'p_issued_date' => ''];

                    switch ($item) {
                        case 'passport_dex':
                            $value_before = isset($passport['p_exp_date']) ? $passport['p_exp_date'] : '';
                            $passport['p_exp_date'] = $value;
                            break;
                        case "passport_doi":
                            $value_before = isset($passport['p_issued_date']) ? $passport['p_issued_date'] : '';
                            $passport['p_issued_date'] = $value;
                            break;
                    }
                    $user->passport = serialize($passport);
                }
                else if (in_array($item, ['phone_home', 'phone_mobile1'])) {
                    $phone = !is_null($user->phone) ? unserialize($user->phone) : ['home' => '', 'mobile1' => ''];

                    switch ($item) {
                        case 'phone_home':
                            $value_before = isset($phone['home']) ? $phone['home'] : '';
                            $phone['home'] = $value;
                            break;
                        case "phone_mobile1":
                            $value_before = isset($phone['mobile1']) ? $phone['mobile1'] : '';
                            $phone['mobile1'] = $value;
                            break;
                    }
                    $user->phone = serialize($phone);
                }
                elseif ($item == 'languages'){
                    /*$languages = $user->languages;
                    $value_before = !is_null($languages)  ? unserialize($languages) : [];
                    debug($value_before);
                    debug($value);
                    $user->languages = serialize($value);*/
                }
                else {
                    $value_before = $user->$item;
                    $user->$item = ($value == '' ? null : $value);
                }
                $user->save();
                ChangeLog::LogChange($crew_id, $user->getTable(), $item, $value_before, $value);
            }
        }
        else {
            switch ($type){
                case "fcm":
                    $crew = CaptainFirstOfficer::where('user_id', $crew_id)->first();
                    break;
                case "ccm":
                    $crew = CabinCrew::where('user_id', $crew_id)->first();
                    break;
                default:
                    $crew = false;
                    break;
            }

            if ($crew){
                if ($item == 'aircraft_types'){
                    $value_before = !is_null($crew->$item)  ? unserialize($crew->$item) : [];
                    $crew->$item = serialize($value);
                }
                elseif (in_array($item, ['is_captain', 'is_purser'])){
                    $value_before = ($crew->$item == 1) ? 1 : 0;

                    debug($value);

                    if ($value == 0) {
                        if ($type == 'fcm')
                            UserDepartment::where('user_id', $crew_id)->update(['position_id' => Position::where('title', 'First Officer')->first(['id'])->id]);
                        elseif($type == 'ccm')
                            UserDepartment::where('user_id', $crew_id)->update(['position_id' => Position::where('title', 'Flight Attendant')->first(['id'])->id]);

                        $crew->$item = null;
                    }
                    elseif ($value == 1) {
                        if ($type == 'fcm')
                            UserDepartment::where('user_id', $crew_id)->update(['position_id' => Position::where('title', 'Captain')->first(['id'])->id]);
                        elseif($type == 'ccm')
                            UserDepartment::where('user_id', $crew_id)->update(['position_id' => Position::where('title', 'Purser')->first(['id'])->id]);

                        $crew->$item = 1;
                    }

                }
                else {
                    $value_before = $crew->$item;
                    $crew->$item = ($value == '' ? null : $value);
                }
                $crew->save();
                ChangeLog::LogChange($crew_id, $crew->getTable(), $item, $value_before, $value);
            }
        }
        return response()->json([
            "message" => "Record Was Successfully Updated",
            "success" => TRUE,
        ]);
    }

    public function ajaxSaveUserHistory(){
        $from_date = request()->get('from_date');
        $to_date = request()->get('to_date');
        $condition_id = request()->get('condition_id');
        $airline_id = request()->get('airline_id');
        $date_format = request()->get('date_format');
        $table = request()->get('table');
        $user_id = request()->get('user_id');
        $history_id = request()->get('history_id');
        $notes = request()->get('notes');

        debug(request()->all());

        if (dateValidation($from_date, $date_format) && dateValidation($to_date, $date_format)) {

            $from_date = date('Y-m-d H:i', strtotime($from_date));
            $to_date = date('Y-m-d H:i', strtotime($to_date));

            if (strtotime($from_date) > strtotime($to_date)){
                return response()->json([
                    "history_id"    => null,
                    "success"       => false,
                ]);
            }

            if (!$condition_id){
                return response()->json([
                    "condition_id"    => null,
                    "success"       => false,
                ]);
            }

            if (strtotime($from_date) > strtotime($to_date)){
                return response()->json([
                    "history_id"    => null,
                    "success"       => false,
                ]);
            }

            if ($history_id == 'add'){

                $user_history = new UserHistory();
                $user_history->user_id= $user_id;
                $user_history->condition_id = $condition_id;
                $user_history->airline_id = $airline_id;
                $user_history->condition_from = $from_date;
                $user_history->condition_to = $to_date;
                $user_history->notes = $notes;
                $user_history->created_by = Auth::user()->id;
                $user_history->save();

                $value = UserHistory::find($user_history->id, ['id', 'condition_id', 'airline_id', 'condition_from', 'condition_to', 'notes'])->toArray();
                ChangeLog::LogChangeArray($user_id, $table, [], $value);
            }
            else {
                $user_history = UserHistory::find($history_id,
                    ['id', 'condition_id', 'airline_id', 'condition_from', 'condition_to', 'notes']
                );

                if ($user_history) {
                    // Before Values For Log
                    $value_before = $user_history->toArray();
                    $user_history->condition_id = $condition_id;
                    $user_history->airline_id = $airline_id;
                    $user_history->condition_from = $from_date;
                    $user_history->condition_to = $to_date;
                    $user_history->notes = $notes;
                    $user_history->updated_by = Auth::user()->id;
                    $user_history->save();

                    $value = UserHistory::find($user_history->id, ['id', 'condition_id', 'airline_id', 'condition_from', 'condition_to', 'notes'])->toArray();
                    ChangeLog::LogChangeArray($user_id, $table, $value_before, $value);
                }
            }
        }


        return response()->json([
            "history_id"    => isset($user_history) ? $user_history->id : null,
            "success"       => isset($user_history) ? TRUE : FALSE,
        ]);

    }

    public function ajaxRemoveUserHistory(){
        $from_date = request()->get('from_date');
        $to_date = request()->get('to_date');
        $condition_id = request()->get('condition_id');
        $airline_id = request()->get('airline_id');
        $date_format = request()->get('date_format');
        $table = request()->get('table');
        $user_id = request()->get('user_id');
        $history_id = request()->get('history_id');

        if ($history_id && $history_id != 'add'){
            $user_history = UserHistory::find($history_id, ['id', 'condition_id','airline_id', 'condition_from', 'condition_to']);
            if ($user_history) {
                ChangeLog::LogChangeArray($user_id, $table, $user_history->toArray(), []);

                $user_history->deleted_at = date("Y-m-d H:i:s");
                $user_history->deleted_by = Auth::user()->id;
                $user_history->save();
            }
        }
        else {
            if (dateValidation($from_date, $date_format) && dateValidation($to_date, $date_format)) {
                $from_date = date('Y-m-d', strtotime($from_date));
                $to_date = date('Y-m-d', strtotime($to_date));

                $user_history = UserHistory::where('user_id', $user_id)
                                            ->where('condition_id', $condition_id)
                                            ->where('condition_from', $from_date)
                                            ->where('condition_to', $to_date)
                                            ->whereNull("deleted_at")
                                            ->first(['id', 'condition_id', 'condition_from', 'condition_to']);

                if ($user_history) {
                    $value_before = $user_history->toArray();
                    ChangeLog::LogChangeArray($user_id, $table, $value_before, []);

                    $user_history->deleted_at = date("Y-m-d H:i:s");
                    $user_history->deleted_by = Auth::user()->id;
                    $user_history->save();
                }
            }
        }

        return response()->json([
            'success'   => isset($user_history) ? TRUE : FALSE,
            'message'   => isset($user_history) ? "Record Deleted Successfully" : "Error! No Records Removed. Please Check Again"
        ]);

    }

    public function ajaxSaveRecordUniversal(){
        $parentId = request()->get('aircraftId');
        $data = request()->get('data');
        $errors = [];

        foreach ($data as $model => $object) {
            $columns = array_merge(['id'], array_unique($object['columns']));
            foreach ($object as $id => $variables) {
                if ($id != 'columns') {
                    $error = false;
                    $modelTrans = "App\\Models\\".$model;
                    $findRecord = $modelTrans::find($id, $columns);

                    if ($findRecord) {
                        $value_before = $findRecord->toArray();
                        foreach ($variables as $name => $item) {
                            $value = $item['value'];
                            $format = isset($item['date_format']) ? $item['date_format'] : false;
                            if ($format != false) {
                                $date = dateValidation($value, $format, 'object');
                                if ($date != false) {
                                    $findRecord->$name = $date->format('Y-m-d H:i:s');
                                } else {
                                    $error = true;
                                    $errors[] = "Date Format Not Recognised";
                                }
                            } else {
                                $findRecord->$name = $item['value'];
                            }
                        }
                        if ($error == false) {
                            switch ($model){
                                case "Maintenance":
                                    if (strtotime($findRecord->arrival_time) < strtotime($findRecord->departure_time)) {
                                        if (Maintenance::checkMaintenanceConflicts($parentId, $findRecord->arrival_time, $findRecord->departure_time, $id)) {
                                            $findRecord->save();
                                            $value = $findRecord->toArray();
                                            ChangeLog::LogChangeArray(null, null, $value_before, $value, $model);
                                        } else {
                                            $errors[] = "Error! Selected Dates Conflicts With Other Records, Please Check Again.";
                                        }
                                    }
                                    else {
                                        $errors[] = "Error! Start Date Cannot Be Set After End Date. Please Check Again.";
                                    }
                                    break;
                            }
                        }
                    } else {
                        $errors[] = 'Record with ID = ' . $id . " Not Found";
                    }
                }
            }
        }

        return response()->json([
            'success'   => count($errors) ? false : true,
            'errors'    => $errors,
            'text'      => count($errors) ? $errors : 'Record Successfully Updated',
            'type'      => count($errors) ? "Error" : "Success"
        ]);
    }
}