<?php namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserTracking;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Contracts\Routing\Registrar;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class AuthController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Registration & Login Controller
	|--------------------------------------------------------------------------
	|
	| This controller handles the registration of new users, as well as the
	| authentication of existing users. By default, this controller uses
	| a simple trait to add these behaviors. Why don't you explore it?
	|
	*/

	use AuthenticatesUsers, RegistersUsers {
		AuthenticatesUsers::redirectPath insteadof RegistersUsers;
		AuthenticatesUsers::guard insteadof RegistersUsers;
	}

	protected $redirectTo;

	/*
    /**
     * Create a new authentication controller instance.
     * @param Guard $auth
     * @param Registrar $registrar
	 *
	public function __construct(Guard $auth, Registrar $registrar)
	{
		$this->auth = $auth;
		$this->registrar = $registrar;

		$this->middleware('guest', ['except' => 'getLogout']);
	}
	*/

	public function getLogin()
	{
		if (view()->exists('auth.authenticate')) {
			return view('auth.authenticate');
		}

		return view('smart.login');
	}

	public function login(Request $request)
	{
		$this->validateLogin($request);



		// If the class is using the ThrottlesLogins trait, we can automatically throttle
		// the login attempts for this application. We'll key this by the username and
		// the IP address of the client making these requests into this application.
		if ($this->hasTooManyLoginAttempts($request)) {
			$this->fireLockoutEvent($request);

			// Save failures
			$this->saveFailedLoginAttempt($request, true);

			return $this->sendLockoutResponse($request);
		}

		if ($this->attemptLogin($request)) {
            $this->saveLogin($request);

			return $this->sendLoginResponse($request);
		}

		// If the login attempt was unsuccessful we will increment the number of attempts
		// to login and redirect the user back to the login form. Of course, when this
		// user surpasses their maximum number of attempts they will get locked out.
		$this->incrementLoginAttempts($request);

		// Save failures
		$this->saveFailedLoginAttempt($request);

		return $this->sendFailedLoginResponse($request);
	}

    function saveLogin(Request $request){
        // Get Ip Details
        $ipDetails = GetIPDetails();

        // Save User Login Access Details
        UserTracking::SaveLog($ipDetails);
    }

	function saveFailedLoginAttempt(Request $request, $tooManyLoginAttempts = null){
		// Get Ip Details
		$ipDetails = GetIPDetails();

		// Save User Login Access Details
		UserTracking::SaveLog($ipDetails, true, $request->get("email"), $request->get("password"), $tooManyLoginAttempts);
	}

	protected function hasTooManyLoginAttempts(Request $request)
	{
		return $this->limiter()->tooManyAttempts(
			$this->throttleKey($request), 3, 60
		);
	}

	protected function attemptLogin(Request $request)
	{
		$user = User::where("email", $request->get("email"))
						->first();

		if (!isUserAllowedToLogin($user)){
			return false;
		}

		return $this->guard()->attempt(
			$this->credentials($request), $request->has('remember')
		);
	}

	protected function authenticated(Request $request, $user)
	{
		$user->last_login = date("Y-m-d H:i:s");
		$user->save();
	}
}
