<?php

namespace App\Http\Controllers;
use App\Models\Flight;

use App\Http\Requests;
use Illuminate\Support\Facades\DB;


class ApiController extends Controller
{
    public function getFlightDetails(){
        // if (isset($_SERVER['HTTP_REFERER']) && parse_url($_SERVER['HTTP_REFERER'])['host'] == 'somonair.com') {
        $flightNumber = \request("flight_number");
        $departureAirport = \request("departure_airport");
        $arrivalAirport = \request("arrival_airport");
        $date = \request("date");
        $type = \request("type");

        $flight = Flight::searchFlightByDateAndFlightNumber($date, $flightNumber, $departureAirport, $arrivalAirport, $type);

        $processedFlights = [];

        // Unserialize Diversion Info
        foreach ($flight as $i => $each) {
            $processedFlights[$i] = $each;
            if ($each->is_diversion){
                $diversion = unserialize($each->diversion);
                foreach ($diversion as $j => $item) {
                    if ($j == 'diversion_airport'){
                        $city = City::find($diversion['diversion_airport']);
                        $processedFlights[$i]->diversion_code = $city ? $city->short_name : "";
                        $processedFlights[$i]->diversion_airport = $city ? $city->city : "";
                        continue;
                    }
                    $processedFlights[$i]->{$j} = $item;
                }
            }
            unset($processedFlights[$i]->diversion);
        }

        return response()->json($processedFlights);
        //}
    }


    public function getTodaysLandedFlights(){

        $type = \request("type") ? \request("type") : 'arrival';

        switch($type){
            case "departure":
                $time = 'std';
                break;

            case "arrival":
            default:
                $time = 'sta';
                break;
        }

        $date = \request("date") ? \request("date") : date('Y-m-d');
        $datePrevious = date('Y-m-d', strtotime('- 1 days', strtotime($date)));
        $dateNext = date('Y-m-d', strtotime('+ 1 days', strtotime($date)));


        $flights = Flight::join('flights__numbers', 'flights__numbers.id', '=', 'flights.flight_number_id')
            ->join('airports AS depAirport', 'depAirport.id', '=', 'flights__numbers.departure_airport_id')
            ->join('airports AS arrAirport', 'arrAirport.id', '=', 'flights__numbers.arrival_airport_id')
            ->leftJoin('cities AS depCity', 'depCity.id', '=', 'depAirport.city_id')
            ->leftJoin('cities AS arrCity', 'arrCity.id', '=', 'arrAirport.city_id')
            ->whereBetween(DB::raw("DATE({$time})"), [$datePrevious, $dateNext])
            ->whereNull('flights.cancelled_at')
            ->whereNull('flights.deleted_at')
            ->orderBy("{$time}")
            ->get([
                'flight_number',
                'depAirport.iata as departure_code',
                'depCity.city as departure_airport',
                'arrAirport.iata as arrival_code',
                'arrCity.city as arrival_airport',
                'std',
                'sta',
                'etd',
                'eta',
                'atd',
                'ata',
                'is_diversion',
                'diversion'
            ]);

        $processedFlights = [];

        // Unserialize Diversion Info
        foreach ($flights as $i => $each) {
            $processedFlights[$i] = $each;
            if ($each->is_diversion){
                $diversion = unserialize($each->diversion);
                foreach ($diversion as $j => $item) {
                    if ($j == 'diversion_airport'){
                        $city = City::find($diversion['diversion_airport']);
                        $processedFlights[$i]->diversion_code = $city ? $city->short_name : "";
                        $processedFlights[$i]->diversion_airport = $city ? $city->city : "";
                        continue;
                    }
                    $processedFlights[$i]->{$j} = $item;
                }
            }
            unset($processedFlights[$i]->diversion);
        }

        return response()->json($processedFlights);
    }


    public function getFlightNumbersRange(){
        $date = \request("date") ? \request("date") : date('Y-m-d');

        $flightNumbers = Flight::join('flights__numbers', 'flights__numbers.id', '=', 'flights.flight_number_id')
            ->where(DB::raw("DATE(TIMESTAMPADD(HOUR, 5, std))"), $date)
            ->whereNull('flights.cancelled_at')
            ->whereNull('flights.deleted_at')
            ->groupBy('flight_number_id')
            ->orderBy('flight_number')
            ->pluck('flight_number');

        return response()->json($flightNumbers);

    }
}
