<?php

namespace App\Http\Controllers;

use App\Models\Airport;
use App\Models\AirportLicense;
use App\Models\License;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;


class AirportLicenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function show()
    {
        $airportId = \request("airport_id");

        $airport = Airport::find($airportId);

        $airportLicenses = AirportLicense::with('license')
                                        ->where("airport_id", $airportId)
                                        ->get();

        $licenses = License::pluck("name", "id");

        $this->viewData = [
            'airport'               => $airport,
            'licenses'              => $licenses,
            'airportLicenses'       => $airportLicenses,
        ];

        return view()->make("airport-license.show", $this->viewData);
    }

    public function editCreate(){

        $airportId = \request("airport_id");
        $airport = Airport::find($airportId);

        $selectedLicenses = [];
        $airportLicenses = AirportLicense::with('license')
                                        ->where("airport_id", $airportId)
                                        ->get();

        foreach ($airportLicenses as $airportLicense) {
            $selectedLicenses[] = $airportLicense->license_id;
        }

        $licenses = License::pluck("name", "id");

        $this->viewData = [
            'airport'               => $airport,
            'licenses'              => $licenses,
            'selectedLicenses'      => $selectedLicenses,
        ];

        return view()->make("airport-license.edit-create", $this->viewData);
    }

    public function updateStore(Request $request)
    {
        $airportId = $request->get("airport_id");

        $this->updateAirportLicenses($request);

        return redirect()->to("airport-license/show?airport_id={$airportId}");
    }

    public function updateAirportLicenses(Request $request){
        $airportId = $request->get("airport_id");
        $licenses = $request->get("license");

        $processedLicenses = [];

        if ($licenses && count($licenses)) {
            $insertArray = [];
            foreach ($licenses as $licenseId) {
                $airportLicense = AirportLicense::where("airport_id", $airportId)
                                                ->where("license_id", $licenseId)
                                                ->first();

                if (!$airportLicense) {
                    $insertArray[] = [
                        'enabled'       => true,
                        'required'      => true,
                        'airport_id'    => $airportId,
                        'license_id'    => $licenseId,
                    ];
                }

                $processedLicenses[] = $licenseId;
            }

            if (count($insertArray)){
                AirportLicense::insert($insertArray);
            }
        }

        // Remove Everything else
        $aLicenses = AirportLicense::where("airport_id", $airportId)
                        ->whereNotIn("license_id", $processedLicenses)
                        ->get();
        // Audit Deleted
        auditDeleted($aLicenses);

    }

    public function delete(AirportLicense $airport_license)
    {
        $airportId = $airport_license->airport_id;

        if ($airport_license){
            // Audit Deleted
            auditDeleted($airport_license);
//            $airport_license->delete();
        }

        return redirect()->to("airport-license/show?airport_id={$airportId}");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
