<?php namespace App\Http\Controllers;

use App\Forms\Airport\AirportUpdateForm;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Models\AirportLicense;
use App\Models\City;
use App\Models\Country;
use App\Models\Location;
use App\Models\StaffStation;
use App\Repositories\Interfaces\IAirportRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class AirportController extends Controller {

	/**
	 * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
	 */
	public function index()
	{
		/*
		$perPage = \request("perPage") ? \request("perPage") : 1000;

		$airports			= Airport::whereNull("handling_airport")->orderBy("operated", "DESC")->paginate($perPage);
		*/

		if (airlineModule()){
		    $handlingAirports = Airport::where("handling_airport", true)->get();
        }
		else {
		    $handlingAirports = StaffStation::currentStaffStationsList(WITH_COUNTRY);
        }

		$this->viewData = [
		    'staffLocations'    => Location::getStaffLocations(),
            "staffLocationAirports" => Location::locationAirports(),
			'onlineAirports'	=> Airport::where("operated", true)->get(),
			'handlingAirports'	=> $handlingAirports,
//			'perPage'			=> $perPage,
//			'currentPage'		=> \request("page") ? \request("page") : 1,
//			'airport'			=> \request("airport"),
//			'airports'			=> $airports,
		];

		return view('airport/index', $this->viewData);
	}

	public function online($airport)
	{
		$page = \request("page");
		$airport->handling_airport = true;
		$airport->operated = true;
		$airport->save();

		flash()->success("Changes Successfully Saved");
		return redirect()->to("airport?page={$page}");
	}

	public function offline($airport)
	{
		$page = \request("page");
		if ($airport->handling_airport){
			$airport->handling_airport = null;
		}
		else {
			$airport->operated = null;
		}
		$airport->save();

		flash()->success("Changes Successfully Saved");
		return redirect()->to("airport?page={$page}");
	}


	/**
	 * @param $airport
	 * @return \Illuminate\View\View
	 */
	public function edit($airport)
	{
		$cities = [];
		if ($airport->country_id){
			$cities = City::listByCountries($airport->country_id);
		}

		$timezones = [];
		foreach (\DateTimeZone::listIdentifiers(\DateTimeZone::ALL) as $each) {
			$timezones[$each] = $each;
		}


		$this->viewData = [
			'airport'				=> $airport,
			'currentPage'			=> \request("page"),
			'countries'				=> Country::getCountries(),
			'cities'				=> $cities,
			'timezones'				=> $timezones
		];

		return view('airport/edit', $this->viewData);
	}

	/**
	 * @param $airport
	 * @return $this|\Illuminate\Http\RedirectResponse
	 */
	public function update($airport)
	{
		if (!$airport){
			return redirect()->back()
				->withInput();
		}

		$airport->name = \request("name");
		$airport->iata = \request("iata");
		$airport->icao = \request("icao");
		$airport->country_id = \request("country");
		$airport->city_id = \request("city") ?  \request("city") : null;
		$airport->elevation = \request("elevation");
		$airport->latitude = \request("latitude");
		$airport->longitude = \request("longitude");
		$airport->timezone = \request("timezone");
		$airport->operated = \request("operated") ? true : null;
		$airport->flight_watch = \request("flight_watch") ? true : null;
		$airport->email_recipients = \request("email_recipients");
		$airport->email_hub = \request("email_hub") ? true : null;
		$airport->stop_emails = \request("stop_emails") ? true : null;
		$airport->save();

		flash()->success("Changes Successfully Saved");
		return redirect()->to("airport");

	}

	/**
	 * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
	 */
	public function add()
	{
		return view("airport/add", $this->viewData);
	}

	/**
	 * @param Request $request
	 * @return \Illuminate\Http\RedirectResponse
	 */
	public function save(Request $request)
	{
		$iata = $request->get("iata");
		$icao = $request->get("icao");

		if ($iata){
            $airport = Airport::where("iata", $iata)
                ->first();
        }
		elseif ($icao){
            $airport = Airport::where("icao", $icao)
                ->first();
        }
		else {
            flash()->error("Please fill one of the fields!");
            return redirect()->back();
        }

		if (!$airport){
			return redirect()->to("airport/create");
		}

		if ($request->get("operated")){
			$airport->operated = true;
		}
		else {
			$airport->handling_airport = true;
			$airport->operated = true;
		}

		$airport->save();

        StaffStation::createCurrentStaffStation($airport);

		return redirect()->to("airport");
	}

	/**
	 * @param Request $request
	 * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
	 */
	public function create(Request $request)
	{
		$timezones = [];
		foreach (\DateTimeZone::listIdentifiers(\DateTimeZone::ALL) as $each) {
			$timezones[$each] = $each;
		}

		$this->viewData = [
			'iata'					=> $request->get("iata"),
			'countries'				=> ["" => "Select"] + Country::getCountries(),
//			'cities'				=> $this->city->listModelVariable(['country', 'id']),
			'citiesByCountry'		=> City::getCitiesByCountry(),
			'timezones'				=> $timezones
		];

		return view("airport/create", $this->viewData);
	}

	/**
	 * @param Request $request
	 * @return \Illuminate\Http\RedirectResponse
	 */
	public function store(Request $request)
	{
	    $airport = null;
	    if ($request->get("icao")){
            $airport = Airport::where("icao", $request->get("icao"))
                            ->first();
        }
	    else if ($request->get("iata")) {
            $airport = Airport::where("iata", $request->get("iata"))
                            ->first();
        }

		if ($airport){
			return redirect()->back();
		}

		$airport = new Airport();
		$airport->handling_airport = $request->get("handling_airport") ? true : null;
		$airport->name = $request->get('name');
		$airport->iata = $request->get('iata');
		$airport->icao = $request->get('icao');
		$airport->country_id = $request->get('country');
		$airport->city_id = $request->get('city');
		$airport->elevation = $request->get('elevation');
		$airport->latitude = $request->get('latitude');
		$airport->longitude = $request->get('longitude');
		$airport->timezone = $request->get('timezone');
		$airport->operated = $request->get('operated') ? true : null;
        $airport->flight_watch = $request->get('flight_watch') ? true : null;
        $airport->email_recipients = $request->get('email_recipients');
		$airport->email_hub = \request("email_hub") ? true : null;
		$airport->stop_emails = \request("stop_emails") ? true : null;
		$airport->save();

		if ($request->get("handling_airport")){
            StaffStation::createCurrentStaffStation($airport);
        }

		return redirect()->to("airport");
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		//
	}


	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
