<?php

namespace App\Http\Controllers;

use App\Models\Airline;
use App\Models\AirlineService;
use App\Models\License;
use App\Models\Service;
use App\Models\AirlineLicense;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;


class AirlineLicenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    public function create()
    {
        //
    }

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\View
     */
    public function show(Request $request)
    {
        $airline = Airline::find($request->get("airline_id"));

        list($services, $selectedLicenses) = AirlineLicense::getServicesAndSelectedLicenses($airline);

        $this->viewData = [
            'airline'               => $airline,
            'services'              => $services,
            'selectedLicenses'      => $selectedLicenses,
        ];

        return view()->make("airline-license.show", $this->viewData);
    }

    public function editCreate(){

        $airlineId = \request("airline_id");
        $serviceId = \request("service_id");

        $airline = Airline::find($airlineId);
        $service = Service::find($serviceId);

        $selectedLicenses = [];
        $airlineLicenses = AirlineLicense::with('license')
            ->where("airline_id", $airlineId)
            ->where("service_id", $serviceId)
            ->get();

        foreach ($airlineLicenses as $airlineLicense) {
            $selectedLicenses[] = $airlineLicense->license_id;
        }

        $licenses = License::pluck("name", "id");

        $this->viewData = [
            'airline'               => $airline,
            'service'               => $service,
            'licenses'              => $licenses,
            'selectedLicenses'      => $selectedLicenses,
        ];

        return view()->make("airline-license.edit-create", $this->viewData);
    }

    public function updateStore(Request $request)
    {
        $airlineId = $request->get("airline_id");

        $this->updateServiceLicenses($request);

        return redirect()->to("airline/{$airlineId}?current_tab=licenses");
    }

    public function updateServiceLicenses(Request $request){
        $airlineId = $request->get("airline_id");
        $serviceId = $request->get("service_id");
        $licenses = $request->get("license");

        $processedLicenses = [];

        if ($licenses && count($licenses)) {
            $insertArray = [];
            foreach ($licenses as $licenseId) {
                $airlineLicense = AirlineLicense::where("airline_id", $airlineId)
                                                  ->where("service_id", $serviceId)
                                                  ->where("license_id", $licenseId)
                                                  ->first();

                if (!$airlineLicense) {
                   $insertArray[] = [
                       'enabled'       => true,
                       'required'      => true,
                       'airline_id'    => $airlineId,
                       'service_id'    => $serviceId,
                       'license_id'    => $licenseId,
                   ];
                }

                $processedLicenses[] = $licenseId;
            }

            if (count($insertArray)){
                AirlineLicense::insert($insertArray);
            }
        }

        // Remove Everything else
        $aLicenses = AirlineLicense::where("airline_id", $airlineId)
                        ->where("service_id", $serviceId)
                        ->whereNotIn("license_id", $processedLicenses)
                        ->get();
        // Audit Deleted
        auditDeleted($aLicenses);

    }

    public function delete(Request $request)
    {
        $airlineId = $request->get("airline_id");
        $serviceId = $request->get("service_id");

        // Remove Everything else
        $aLicenses = AirlineLicense::where("airline_id", $airlineId)
                        ->where("service_id", $serviceId)
                        ->get();

        // Audit Deleted
        auditDeleted($aLicenses);


        return redirect()->to("airline/{$airlineId}?current_tab=licenses");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
