<?php

namespace App\Http\Controllers;

use App\Models\Aircraft;
use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightSector;
use App\Models\StaffAirline;
use App\Models\StaffStation;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;


class AircraftUtilizationController extends Controller
{

    const MAX_EXECUTION_TIME = 120;

    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);

        ini_set('memory_limit', '256M');

        // Get Staff Handling AP and Airlines
        list($handlingAirlines, $handlingAirports) = getStaffHandlingAirports();

        $selectedAirports = $request->has("airport") ? $request->get("airport") : array_keys($handlingAirports);
        $selectedAirlines = $request->has("airline") ? $request->get("airline") : array_keys($handlingAirlines);

        $flights  = Flight::FlightsRangeConditional($selectedAirports, $selectedAirlines);
        $data = Aircraft::groupData($flights);

        $acTypes = AircraftType::byAirline($selectedAirlines, true);
                                /* AircraftType::whereNotNull("icao")
                                ->where("icao", "!=", "")
                                ->pluck("icao", "id")->all(),*/

        // Data Array
        $this->viewData = [
            'data'              => $data,
            'dateYesterday'     => date('Y-m-d',strtotime(" - 1 days")),

            "aircraftTypes"     => $acTypes,
            "aircraft"          => Aircraft::whereNull("deleted_at")
                                            ->whereNotNull("name")
                                            ->where("name", "!=", "")
                                            ->orderBy("name")
                                            ->pluck("name", "id")
                                            ->all(),

            "airlines"          => ["" => "Select"] + $handlingAirlines,
            "airports"          => $handlingAirports,

            "flightNumbers"     => FlightNumber::getArrayFlightNumbersWithSector(false, false, false, null, true),
            'sectors'           => FlightSector::listSectors(),
            'sectorsByAirlines' => FlightSector::getSectorsByAirlines(),

            'periods'           => getPeriodsArray([6]),
            'monthNames'        => getMonthsArray(),
            'years'             => getYearsArray(),
        ];

        return view('aircraft-utilization.index', $this->viewData);
    }





    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
