<?php

namespace App\Http\Controllers;

use App\Models\Aircraft;
use App\Models\AircraftEngine;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AircraftEngineController extends Controller
{
    public function index(Request $request){
        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,

            "engines"  => AircraftEngine::get(),
        ];

        return view("aircraft-engine/index", $this->viewData);
    }

    public function create(Request $request){

        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "aircraftID"    => $aircraftID,
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,
        ];

        return view("aircraft-engine/create", $this->viewData);
    }

    public function edit(Request $request, $aircraft_engine){

        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "engine"        => $aircraft_engine,
            "aircraftID"    => $aircraftID,
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,
        ];

        return view("aircraft-engine/edit", $this->viewData);
    }

    public function update(Request $request, $aircraft_engine){

        $search = AircraftEngine::where('id', "!=", $aircraft_engine->id)
            ->where(function($sql) use ($request) {
            $sql->where("name", $request->get("name"))
                ->orWhere("abbr", $request->get("abbr"));
        })->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $aircraft_engine->name = $request->get("name");
        $aircraft_engine->abbr = $request->get("abbr");
        $aircraft_engine->updated_by = Auth::user()->id;
        $aircraft_engine->save();

        return redirect()->to("aircraft-engine");
    }


    public function store(Request $request){

        $search = AircraftEngine::where("name", $request->get("name"))
                                    ->orWhere("abbr", $request->get("abbr"))
                                    ->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $cert = new AircraftEngine();
//        $cert->aircraft_id = $aircraftID;
        $cert->name = $request->get("name");
        $cert->abbr = $request->get("abbr");
//        $cert->effective_from = $request->get("effective_from");
//        $cert->effective_to = $request->get("effective_to");
        $cert->created_by = Auth::user()->id;
        $cert->save();

        return redirect()->to("aircraft-engine");
    }

    public function delete($aircraft_engine){

        if ($aircraft_engine){
            $aircraft_engine->delete();
        }
        return redirect()->to("home#aircraft-engine");
    }

}
