<?php

namespace App\Http\Controllers;

use App\Models\Aircraft;
use App\Models\AircraftCertificate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AircraftCertificateController extends Controller
{

    public function index(Request $request){
        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,

            "certificates"  => AircraftCertificate::get(),
        ];

        return view("aircraft-certificate/index", $this->viewData);
    }

    public function create(Request $request){

        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "aircraftID"    => $aircraftID,
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,
        ];

        return view("aircraft-certificate/create", $this->viewData);
    }

    public function edit(Request $request, $aircraft_certificate){

        $aircraftID = $request->get("aircraft_id");

        $this->viewData = [
            "certificate"   => $aircraft_certificate,
            "aircraftID"    => $aircraftID,
            "aircraft"      => $aircraftID ? Aircraft::find($aircraftID) : null,
        ];

        return view("aircraft-certificate/edit", $this->viewData);
    }

    public function update(Request $request, $aircraft_certificate){

        $search = AircraftCertificate::where('id', "!=", $aircraft_certificate->id)
            ->where(function($sql) use ($request) {
            $sql->where("certificate_name", $request->get("name"))
                ->orWhere("certificate_abbr", $request->get("abbr"));
        })->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $aircraft_certificate->certificate_name = $request->get("name");
        $aircraft_certificate->certificate_abbr = $request->get("abbr");
        $aircraft_certificate->updated_by = Auth::user()->id;
        $aircraft_certificate->save();

        return redirect()->to("aircraft-certificate");
    }


    public function store(Request $request){

        $search = AircraftCertificate::where("certificate_name", $request->get("name"))
                                    ->orWhere("certificate_abbr", $request->get("abbr"))
                                    ->first();

        if ($search){
            return redirect()->back()->withInput($request->all());
        }

        $cert = new AircraftCertificate();
//        $cert->aircraft_id = $aircraftID;
        $cert->certificate_name = $request->get("name");
        $cert->certificate_abbr = $request->get("abbr");
//        $cert->effective_from = $request->get("effective_from");
//        $cert->effective_to = $request->get("effective_to");
        $cert->created_by = Auth::user()->id;
        $cert->save();

        return redirect()->to("aircraft-certificate");
    }

    public function delete($aircraft_certificate){

        if ($aircraft_certificate){
            $aircraft_certificate->delete();
        }
        return redirect()->to("aircraft-certificate");
    }

}
