<?php namespace App\Http\Controllers;

use App\Classes\Image\CropAvatar;
use App\Http\Requests;
use App\Http\Controllers\Controller;

use App\Models\Agency;
use App\Models\AgencyCode;
use App\Models\City;
use App\Models\Country;
use App\Models\SalesChannel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;

class AgencyCodeController extends Controller
{
    /**
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $countries = getApprovedCountryList();

        $countryIDs = array_keys($countries);

        $agencyCodes = AgencyCode::getByCountry($countryIDs, $request->get("agency_id"));

        $agenciesByCountry = ["" => "Select"] + Agency::getByCountry($countryIDs);

        debug($agenciesByCountry);

        $this->viewData = [
            'agencyCodes'			=> $agencyCodes,
            'agenciesByCountry'     => $agenciesByCountry,
        ];

        return view('agency-code/index', $this->viewData);
    }

    public function add()
    {
        $countries = getApprovedCountryList();

        $countryIDs = array_keys($countries);

        $citiesByCountry = City::getCitiesByCountry($countryIDs);

        $agenciesByCountry = Agency::getAgenciesByCountry($countryIDs);

        $this->viewData = [
            'countries'		        => ["" => "Select"] + $countries,
            'citiesByCountry'       => $citiesByCountry,
            'agenciesByCountry'     => $agenciesByCountry,
        ];

        return view('agency-code/add', $this->viewData);
    }


    public function create(Request $request){

        $attributes = $request->all();
        unset($attributes["_token"]);

        $agencyCode = AgencyCode::create($attributes);

        return redirect()->to("agency-code");
    }

    

    public function edit($agency_code)
    {
        $countries = getApprovedCountryList();

        $countryIDs = array_keys($countries);

        $citiesByCountry = City::getCitiesByCountry($countryIDs);

        $agenciesByCountry = Agency::getAgenciesByCountry($countryIDs);

        $this->viewData = [
            'agencyCode'            => $agency_code,

            'countries'		        => ["" => "Select"] + $countries,
            'citiesByCountry'       => $citiesByCountry,
            'agenciesByCountry'     => $agenciesByCountry,
        ];

        return view('agency-code/edit', $this->viewData);
    }

    public function link(Request $request){
        debug($request->all());

        $agencyID = $request->get("agency") ? $request->get("agency") : null;
        $agencyCodeIDs = $request->get("code");

        if (!count($agencyCodeIDs)){
            return redirect()->back();
        }

        AgencyCode::whereIn("id", $agencyCodeIDs)
                    ->update(["agency_id" => $agencyID]);

        return redirect()->back();
    }

    public function update(Request $request, $agency_code){

        $attributes = $request->all();
        unset($attributes["_token"]);

        $agency_code->update($attributes);

        return redirect()->to("agency-code");
    }

}
