<?php namespace App\Http\Controllers;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 19.08.14

 */

use App\Forms\UserForm;
use App\Mail\TemplateEmail;
use App\Models\CabinCrew;
use App\Models\CaptainFirstOfficer;
use App\Models\Country;
use App\Models\Department;
use App\Models\Location;
use App\Models\ModulePermission;
use App\Models\Nationality;
use App\Models\Position;
use App\Models\SubDepartment;
use App\Models\UserDepartment;
use App\Models\UserModule;
use App\Models\UserRole;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

use App\Models\Module;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;

class AdminController extends Controller
{
    public function users(Request $request)
    {
        // Redirect If Not Found
        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
            return view("smart/ajax/error401");
        }

        debug($request->all());

        $departments  = [];
        $authObj = $this->authObject;
        $user_department = Auth::user()->department->first();
        $search = null;
        $departments = getDepartmentListByRole($authObj);

        $authRoleID = Auth::user()->user_role_id;

        if (in_array($authRoleID, [ROLE_ADMIN, ROLE_SUPER_ADMIN])) {
            $departments = ['' => 'Select'] + Department::pluck('name', 'id')->all();

            if (\request("role_id") && \request("role_id")){
                $user_id = \request("user_id");
                $role_id = \request("role_id");

                if (in_array($role_id, [ROLE_SUPER_ADMIN])){
                    flash()->error("Global Admin Privileges are limited. Please choose 'Department Admin' role instead.");
                }
                else {

                    if ($authRoleID == ROLE_ADMIN && in_array($role_id, [ROLE_ADMIN])){
                        flash()->error("Granted permissions are up to 'Department Admin'");
                    }
                    else {
                        $findUser = User::find($user_id);
                        if ($findUser) {
                            $findUser->user_role_id = $role_id;
                            $findUser->save();

                            flash()->success("User Role Successfully Saved.");
                        }
                    }
                }
            }
        }
        else if (Auth::user()->user_role_id == ROLE_DEPARTMENT_ADMIN){
            $departments = Department::where('id',$user_department->id)->pluck('name', 'id')->all();
        }

        if (request()->all())
        {
            $first_name = \request("first_name");
            $last_name = \request("last_name");
            $department = \request("department");
            $search = \request("search");
            $privilege = \request("privilege");

            if ($authObj->user() && $authObj->user()->role) {
                if (in_array($authObj->user()->role->role, [ADMIN, SUPER_ADMIN])) {
                    $users = User::getUsersByDepartment(null, null, TRUE, true)
                        ->where(function($sql){
                            $sql->whereNull("users.resigned_date")
                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                        });
                }
                else if ($authObj->user()->role->role == DEPARTMENT_ADMIN) {
                    $users = User::getUsersByDepartment($user_department->id, null, TRUE)
                        ->where(function($sql){
                            $sql->whereNull("users.resigned_date")
                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                        });
                }
            }

            if ($first_name){
                $users->where('first_name', 'LIKE', "%$first_name%");
            }

            if ($last_name){
                $users->where('last_name', 'LIKE' , "%$last_name%");
            }

            if ($department){
                $users->where('structure__departments.id', $department);
            }

            if ($privilege){
                $users->where("user_role_id", $privilege);
            }

//            $users = $users->paginate(10);

            if ($request->get("status")){
                switch ($request->get("status")){
                    case DELETED:
                        $users->whereNotNull("users.deleted_at");
                        break;

                    case ACTIVATED:
                        $users->where("activated", 1);
                        break;

                    case DEACTIVATED:
                        $users->whereNull("users.deleted_at")
                              ->where("activated", "!=", 1);
                        break;
                }
            }

            if (!$users || (is_array($users) && count($users) == 0))
            {
                flash()->error("Not found any user by given conditions");
            }
            $users = $users->get();

            debug($users);
        }

        return view("admin/users", [
            "roles"         => ["" => "N/A"] + UserRole::where("role", "!=", SUPER_ADMIN)->pluck("label", "id")->all(),
            "statuses"      => getUserStatuses(),
            "departments"   => $departments,
            "users"         => isset($users) ? $users : [],
            "search"        => $search
        ]);
    }

    public function ajaxSendTempPassword(){
        $user_id = \request("user_id");
        $user = User::find($user_id);
        $success = false;
        if ($user){
            if (isUserAllowedToLogin($user)) {
                $subject = env(AIRLINE);
                $generatePassword = generateRandomPassword();
                $user->password = Hash::make($generatePassword);
                $user->tmp_password = $generatePassword;
                $user->save();

                if (isProductionEnv()) {
                    Mail::to($user->email)
//                    ->bcc("dilovar88@mail.ru")
                        ->send(new TemplateEmail(view("emails/auth/tmp_password", [
                                "user" => $user
                            ])->render()
                        , $subject . " TEMP PASSWORD"));
                }

                $success = true;
                $message = 'User Login Information Successfully Sent.';

            }
            else {
                $message = 'User is not allowed to login. Please contact administrator to restore access.';
            }
        }
        else {
            $message = 'User Not Found. Please Check Again.';
        }

        return response()->json([
            'success'       => $success,
            'message'       => $message
        ]);
    }

    public function ajaxUserActivation(){
        $user_id = \request("user_id");
        $status = \request("status");
        $success = false;
        $user = User::findOrFail($user_id);

        if ($user){
            $user->activated = $status;
            $user->save();
            $success  = true;
        }

        return response()->json([
            'success'       => $success,
            'messageType'   => $success ? 'Success' : 'Error',
            'text'          => $success ? 'User Profile Successfully Updated' : 'Error! Failed To Update User Profile'
        ]);
    }

    public function addUser()
    {
        // Redirect If Not Found
        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
            return redirect()->to('error/page-not-found');
        }

        $user_department_id = getMyDepartmentId($this->authObject->user());

        $form = new UserForm();
        $url = URL::full();

        if ($this->isPostRequest()) {
            if ($form->isValidForRegister()) {
                debug(request()->all());

                $user = new User;
                $user->first_name = \request("first_name");
                $user->last_name = \request("last_name");
                $user->email = trim(\request("email"));
                $user->is_contractor = \request("is_contractor");
                $user->dob = \request("dob");
                $user->location_id = \request("location");
                $user->pob_country_id = \request("birth_place");
                $user->nationality_id = \request("nationality");
                $user->idcard_number = \request("idcard_number");
                $user->idcard_expiry = \request("idcard_expiration");

                $languages = \request("language");
                if (is_array($languages)) {
//                    $user->languages = serialize($languages);
                }
                $user->phone = serialize([
                    "office"  => \request("phone_office"),
                    "home"    => \request("phone_office"),
                    "mobile1" => \request("phone_mobile1"),
                    "mobile2" => \request("phone_mobile2")
                ]);
                $user->passport_num = \request("p_number");
                $user->passport_doi = \request("p_issued_date");
                $user->passport_dex = \request("p_exp_date");

                $user->password = Hash::make(\request("password"));

                $user->save();

                $userDepartment = UserDepartment::where("user_id", "=", $user->id)
                    ->first();
                if (!$userDepartment) {
                    $userDepartment = new UserDepartment();
                    $userDepartment->user_id = $user->id;
                }

                $subDepartmentId = \request("subdepartment_id");
                $departmentId = \request("department_id");
                $userDepartment->department_id = $departmentId;
                $userDepartment->subdepartment_id = $subDepartmentId;

                if (\request("position_id") && \request("position_id")) {
                    if (\request("position_id") == "other" && \request("other_position")) {
                        $position = Position::create([
                            "title" => \request("other_position"),
                            "department_id" => $departmentId,
                            "subdepartment_id" => $subDepartmentId,
                            "created_at" => date("Y-m-d H:i:s"),
                            "created_by" => Auth::id(),
                            "updated_at" => date("Y-m-d H:i:s")
                        ]);
                        $userDepartment->position_id = $position->id;
                    } else {
                        $userDepartment->position_id = \request("position_id");
                    }
                }

                $userDepartment->save();

                if (in_array($userDepartment->position_id, [1, 2])) {
                    $capt_fo = new CaptainFirstOfficer;
                    $capt_fo->user_id = $user->id;
                    $capt_fo->is_captain = $userDepartment->position_id == 1 ? 1 : null;
                    $capt_fo->save();
                }
                elseif (in_array($userDepartment->position_id, [3, 4])) {
                    $psr_cc = new CabinCrew;
                    $psr_cc->user_id = $user->id;
                    $psr_cc->is_purser = $userDepartment->position_id == 4 ? 1 : null;
                    $psr_cc->save();
                }

                return redirect()->to('admin/users')
                    ->withInput()
                    ->with("message", "Account Successfully Created");
            }

            return redirect()->to($url)
                ->withInput()
                ->withErrors($form->getErrors());
        }

        $subDepartments = ["" => "Select Subdivision"] +
            SubDepartment::where("department_id", "=", $user_department_id)
                ->pluck("name", "id")
                ->all();

        return view("admin/add-user", [
            "departments"       => getDepartmentListByRole($this->authObject),
            "nationality"       => ['' => 'Select'] + Nationality::pluck('nationality', 'id')->all(),
            "placeOfBirth"      => ['' => 'Select'] + Country::pluck('country', 'id')->all(),
            "subDepartments"    => $subDepartments,
            "positions"         => Auth::user()->role == ADMIN ? [] : Position::getPositionsByDepartment($user_department_id),
            "location"          => ["" => "Select"] + Location::locationAirports(),
            "user"              => isset($user) ? $user : null
        ]);
    }

    public function ajaxUserDeleteRestore(){
        $user_id = \request("user_id");
        $deleteRestoreType = \request("deleteRestoreType");
        $success = false;
        $user = User::findOrFail($user_id);

        debug(request()->all());

        if ($user){
            $time = date('Y-m-d H:i:s');

            $userDepartment = UserDepartment::where('user_id', $user_id)->first();
            switch ($deleteRestoreType){
                case "Permanent Deletion":
                    if (in_array($userDepartment->position_id, [1, 2])){
                        $cpt = CaptainFirstOfficer::where('user_id', $user->id)
                                                ->get();
                        // Audit Deleted
                        auditDeleted($cpt);

                    }
                    elseif (in_array($userDepartment->position_id, [3, 4])){
                        $cc = CabinCrew::where('user_id', $user->id)
                                        ->get();
                        // Audit Deleted
                        auditDeleted($cc);

                    }

                    if ($userDepartment){
                        // Audit Deleted
                        auditDeleted($userDepartment);
//                        $userDepartment->delete();
                    }

                    // Audit Deleted
                    auditDeleted($user);
//                    $user->delete();

                    $text = ' Successfully Deleted';
                    break;
                case "Delete":
                    $user->activated = 0;
                    $user->updated_by = Auth::user()->id;
                    $user->deleted_at = $time;
                    $user->save();
                    $text = ' Successfully Deleted';
                    break;
                case "Restore":
                    $user->updated_by = Auth::user()->id;
                    $user->deleted_at = null;
                    $user->save();
                    $text = ' Successfully Restored';
                    break;
            }
            $success  = true;
        }

        return response()->json([
            'success'       => $success,
            'messageType'   => $success ? 'Success' : 'Error',
            'text'          => $success ? 'User '. $user->first_name .' '.$user->last_name. $text : 'Error! Failed To Delete User'
        ]);
    }

    public function usersModules(Guard $auth){

        // Redirect If Not Found
        if (!Auth::user() || Auth::user() == '' || !userAnyAdmin()) {
            return view("smart/ajax/error401");
        }

        $admin_modules = Module::whereNull('department_id')->get();
        $departments = getDepartmentListByRole($auth);
        $departments_modules = getDepartmentObjectByRole($auth);

        if (request()->all()) {
            $users = User::with(['userModule', 'userModule.module', 'department'])
                ->select('users.*')
                ->whereNull("vs");
            $first_name = \request("first_name");
            $last_name = \request("last_name");
            $department = \request("department");
            $privilege = \request("privilege");

            if (!is_null($department) && $department != ''){
                $users->join('users__departments', 'users__departments.user_id', '=', 'users.id')
                    ->where('department_id', $department);
            }

            if (!is_null($first_name))
                $users->where('first_name', 'LIKE', $first_name.'%');

            if (!is_null($last_name))
                $users->where('last_name', 'LIKE', $last_name.'%');

            if ($privilege){
                $users->where("user_role_id", $privilege);
            }

            $users->where(function($sql){
                        $sql->whereNull("users.resigned_date")
                            ->orWhere("users.resigned_date", EMPTY_DATE)
                            ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                    })
                    ->whereNull('deleted_at');

            $users = $users->paginate(10);
        }

        $data = [
            "roles"                 => UserRole::where("role", "!=", SUPER_ADMIN)->pluck("label", "id")->all(),
            'departments'           => $departments,
            'admin_modules'         => $admin_modules,
            'users'                 => isset($users) ? $users : [],
            'departments_modules'   => $departments_modules,
        ];

        return view('admin.users-modules', $data);
    }

    public function ajaxUsersModulesSave(){
        $data = \request("data");
        $user_id = \request("user_id");
        $data_add = isset($data['add']) ? $data['add'] : [];
        $data_remove = isset($data['remove']) ? $data['remove'] : [];

        foreach ($data_remove as $item){
            if (isset($item['module_id'])) {
                $user_module = UserModule::where('user_id', $user_id)
                    ->where('module_id', $item['module_id'])
                    ->get();

                // Audit Deleted
                auditDeleted($user_module);

            }
            else if (isset($item['permission_id'])) {
                foreach ($item['permission_id'] as $permission) {
                    $user_module = UserModule::where('user_id', $user_id)
                        ->where('module_permission_id', $permission)
                        ->get();

                    // Audit Deleted
                    auditDeleted($user_module);

                }
            }
        }

        foreach ($data_add as $item){
            if (isset($item['permission_id'])) {
                foreach ($item['permission_id'] as $permission) {
                    $user_module = UserModule::where('user_id', $user_id)
                        ->where('module_id', $item['module_id'])
                        ->where('module_permission_id', $permission)
                        ->first();

                    if (empty($user_module)) {
                        $user_module = new UserModule;
                        $user_module->user_id = $user_id;
                        $user_module->module_id = $item['module_id'];
                        $user_module->module_permission_id = $permission;
                        $user_module->updated_by = Auth::user()->id;
                        $user_module->created_by = Auth::user()->id;
                        $user_module->save();
                    }
                }
            }
            else {
                $user_module = UserModule::where('user_id', $user_id)
                    ->where('module_id', $item['module_id'])
                    ->first();

                if (empty($user_module)){
                    $module_permission = ModulePermission::where('module_id', $item['module_id'])
                        ->whereNotNull('default_permission')
                        ->first();
                    if (empty($module_permission)){
                        $module_permission = new ModulePermission;
                        $module_permission->module_id = $item['module_id'];
                        $module_permission->name = 'Default';
                        $module_permission->default_permission = 1;
                        $module_permission->updated_by = Auth::user()->id;
                        $module_permission->created_by = Auth::user()->id;
                        $module_permission->save();
                    }

                    $user_module = new UserModule;
                    $user_module->user_id = $user_id;
                    $user_module->module_id = $item['module_id'];
                    $user_module->module_permission_id = $module_permission->id;
                    $user_module->updated_by = Auth::user()->id;
                    $user_module->created_by = Auth::user()->id;
                    $user_module->save();

                }
            }
        }



        return response()->json([
            "success"   => TRUE,
            'message'   => 'New Changes Successfully Saved'
        ]);
    }

    public function addHub()
    {
        $cities = City::pluck("city", "id")->all();
        $url   = URL::full();


        if ($this->isPostRequest())
        {
            $form = new HubForm();
            if ($form->isValidHub())
            {
                $hub = new Hub;
                $hub->name        = \request("name");
                $hub->city_id     = \request("city_id");
                if (\request("is_crew_hub"))
                    $hub->is_crew_hub = 1;

                $hub->created_by = Auth::user()->id;
                $hub->save();

                return redirect()->to("crewroster/index")
                    ->with("aircraft_message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "New Hub was successfully added"
                    ]);
            }
            return redirect()->to($url)
                ->withInput()
                ->withErrors($form->getErrors());
        }


        return view("admin/add-hub", [
            "cities" => ["" => "Select City"] + $cities
        ]);
    }

    public function editHub()
    {
        $cities = City::pluck("city", "id")->all();
        $hub = Hub::findOrFail(\request("id"));
        $url          = URL::full();

        if ($this->isPostRequest())
        {
            $form = new HubForm();
            if ($form->isValidHub())
            {
                $hub->name       = \request("name");
                $hub->city_id    = \request("city_id");
                if (\request("is_hub"))
                    $hub->is_hub = 1;
                else
                    $hub->is_hub = 0;

                if (\request("is_crew_hub"))
                    $hub->is_crew_hub = 1;
                else
                    $hub->is_crew_hub = 0;

                $hub->updated_by           = Auth::id();
                $hub->save();
                return redirect()->to("crewroster/index")
                    ->with("aircraft_type_message", [
                        "type" => MESSAGE_SUCCESS,
                        "text" => "Hub \"$hub->name\" was successfully updated"
                    ]);
            }
            return redirect()->to($url)
                ->withInput()
                ->withErrors($form->getErrors());
        }

        return view("admin/edit-hub", [
            "hub" => $hub,
            "cities" => $cities
        ]);



    }

    public function deleteHub()
    {
        $hub = Hub::findOrFail(\request("id"));
        $hub->deleted_at = date("Y-m-d H:i:s");
        $hub->save();
        return redirect()->to("crewroster/index")
            ->with("aircraft_type_message", [
                "type" => MESSAGE_SUCCESS,
                "text" => "Hub \"$hub->name\" was successfully updated"
            ]);
    }

}
