<?php namespace App\Forms;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 20.08.14

 */



class UserForm extends BaseForm
{
    /**
     * Validate data before update user
     * @return mixed
     */
    public function isValidForEdit()
    {
        $common_rules = [
            "id"            => "exists:users,id",
            "first_name"    => "required|alpha|min:2",
            "last_name"     => "required|alpha|min:2",
            "email"         => "required|email|unique:users,email," . \request("id"),
            "department_id" => "required|exists:structure__departments,id"
        ];
        $messages     = [];
        /*if (\request("department_id"))
        {
            $department = Department::find(\request("department_id"));
            if ($department->is_exists_subdepartment)
            {
                $common_rules["subdepartment_id"] = "required|exists:subdepartments,id";
            }
            else
            {
                $common_rules["position_id"] = "required";
            }
        }
        if (\request("subdepartment_id"))
        {
            $common_rules["subdepartment_id"] = "required|exists:subdepartments,id";
            $common_rules["position_id"] = "required";
        }*/
        if (\request("new_password"))
        {
            Validator::extend("hashmatch", function ($attribute, $value, $parameters)
            {
                $user = User::findOrFail(\request("id"));
                return Hash::check($value, $user->getAuthPassword());
            });

            $messages = [
                "hashmatch" => "Entered password does not match with current account password"
            ];

            if (Auth::user()->role == 'user') {
                $password_rules["password"] = "required|min:6|hashmatch:password";
            }
            elseif (Auth::user()->role == 'department_admin'){
                // Department Of Person Who is Being Edited
                $usersDepartment = UserDepartment::where('user_id', \request("id"))->first(['department_id']);

                // Department of A Person Who Tries To Edit
                $departmentId = getMyDepartmentId();
                if ($usersDepartment && !$usersDepartment->department_id == $departmentId) {
                        $password_rules["password"] = "required|min:6|hashmatch:password";
                }
            }

            $password_rules["new_password"] = "required|min:6|confirmed";
            $password_rules["new_password_confirmation"] = "required";

            $common_rules = $common_rules + $password_rules;
        }
        return $this->isValid($common_rules, $messages);
    }

    /**
     * Validate data before create new user
     */
    public function isValidForRegister()
    {
        $rules = array(
            "first_name"            => "required|alpha_dash|min:2",
            "last_name"             => "required|alpha_dash|min:2",
            "email"                 => "required|email|unique:users",
            "password"              => "required|between:6,20|confirmed",
            "password_confirmation" => "required|between:6,20",
            "department_id"         => "required|exists:structure__departments,id",
            "position_id"           => "required",
        );
        /*"subdepartment_id"      => "exists:subdepartments,id"*/

        // set department and sub department rules
        /*$department = Department::find(\request("department_id"));
        if ($department)
        {
            if ($department->is_exists_subdepartment)
            {
                $rules["subdepartment_id"] = "required|exists:subdepartments,id";
            }
            else
            {
                unset($rules["subdepartment_id"]);
            }
        }*/

        // set position rules
        if (\request("position_id") == "other")
        {
            $rules["other_position"] = "required";
        }
        else
        {
            $rules["position_id"] = "required|exists:structure__positions,id";
        }

        return $this->isValid($rules);
    }

   /**
     * Validate data before create new user
     */
    public function isValidForCreation()
    {
        $rules = array(
            "first_name"                => "required|min:2",
            "last_name"                 => "required|min:2",
            "email"                     => "required|email|unique:users",
            "structure_department_id"   => "required|exists:structure__departments,id",
//            "password"                  => "sometimes|required|between:6,20|confirmed",
//            "password_confirmation"     => "sometimes|required|between:6,20",
        );

        return $this->isValid($rules);
    }



}
