<?php namespace App\Forms;


/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 03.09.14

 */
class StandbyForm extends BaseForm
{

    /**
     * Validate add captain and first officer form
     * @return mixed
     */
    public function isValidAddCaptainAndFirstOfficer()
    {
        $rules = [
            "start_date"       => "required|date_format:Y-m-d H:i:s",
            "end_date"         => "required|date_format:Y-m-d H:i:s",
            "airport_id"       => "required",
        ];

        if (\request("captain_id")){
            $rules["captain_id"]        = "required|exists:users,id";
        }

        if (\request("first_officer_id")){
            $rules["first_officer_id"]  = "required|exists:users,id";
        }


        return $this->isValid($rules);
    }

    /**
     * Validate add cabin crew form
     * @return mixed
     */
    public function isValidAddCabinCrew()
    {
        $rules = [
            "flight_attendant_id" => "required|exists:users,id",
            "start_date"          => "required|date_format:Y-m-d H:i:s",
            "end_date"            => "required|date_format:Y-m-d H:i:s",
            "airport_id"          => "required"
        ];
        return $this->isValid($rules);
    }
}
