<?php namespace App\Forms;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
class ReportForm extends BaseForm
{
    /**
     * Validate aircraft before save to DB
     * @return mixed
     */
    public function seatFactorSubmit()
    {
        return $this->isValid([
            "from_date"   =>  "required|date_format:Y/m/d",
            "to_date"     =>  "required|date_format:Y/m/d",
        ]);
    }

    /**
     * Validate aircraft edit form
     * @return mixed
     */















    public function isValidAircraftForEdit()
    {
        $maintenance_rules = [];
        if (\request("add_maintenance"))
        {
            // was attempt to add new maintenance
            $maintenance_rules = [
                "note"           => "required|min:3",
                "location_code"  => "required|min:3",
                "arrival_time"   => "required",
                "departure_time" => "required"
            ];
        }
        else if (\request("maintenance_id"))
        {
            // edit existing maintenance
            $maintenance_rules = [
                "note"           => "required|min:3",
                "location_code"  => "required|min:3",
                "arrival_time"   => "required",
                "departure_time" => "required",
                "maintenance_id" => "required|exists:aircrafts_maintenances,id"
            ];
        }

        return $this->isValid($maintenance_rules + [
                "name"     => "required|min:3",
                "id"       => "required|exists:aircraft,id",
                "type_id"  => "required|exists:aircraft__types,id",
                "config_c" => "integer",
                "config_y" => "integer"
            ]);

    }

    /**
     * Validate aircraft type before save to DB
     * @return mixed
     */
    public function isValidType()
    {
        return $this->isValid([
            "name"    => "required|min:2",
            "details" => "required|min:2"
        ]);
    }
}
