<?php namespace App\Forms;

/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: intranet.dev
 */



class FlightScheduleForm extends BaseForm
{

    public function isValidForm()
    {
        $rules  = [
            "load_date" => "required"
        ];
        $source = \request("source");

        if ($source == "template")
        {
            $rules["template_id"] = "required|exists:flights__schedule,id";
        }
        else if ($source == "fleetwatch")
        {
            $loadDate = \request("load_date");
            if ($loadDate == "from_to")
            {
                $rules["from"] = "required|date_format:Y-m-d";
                $rules["to"]   = "required|date_format:Y-m-d";
            }
            else if ($loadDate == "week")
            {
                $rules["year"] = "required|integer|min:2013|max:" . date("Y");
                $rules["week"] = "required|integer|min:1|max:53"; // max number of week is 53
            }
        }

        return $this->isValid($rules);
    }
}
