<?php namespace App\Forms;


/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 29.08.14

 */


class FlightForm extends BaseForm
{

    /**
     * Validate input data before create new flight
     * @param bool|false $handling
     * @return mixed
     */
    public function isValidForAdd($handling = false)
    {

        $rules = [
            "std"              => "nullable|date_format:Y-m-d H:i",
            "etd"              => "nullable|date_format:Y-m-d H:i",
            "atd"              => "nullable|date_format:Y-m-d H:i",
            "abn"              => "nullable|date_format:Y-m-d H:i",
            "sta"              => "nullable|date_format:Y-m-d H:i",
            "eta"              => "nullable|date_format:Y-m-d H:i",
            "ata"              => "nullable|date_format:Y-m-d H:i",
            "pax_c_actual"     => "nullable|integer",
            "pax_y_actual"     => "nullable|integer",
            "pax_inf_actual"   => "nullable|integer",
            "baggage"          => "nullable|integer",
            "cargo"            => "nullable|integer",
            "mail"             => "nullable|integer",
            "deportees"        => "nullable|integer",
            "in_tanks"         => "nullable|numeric",
            "uplifted"         => "nullable|numeric",
            "utilised"         => "nullable|numeric",
        ];

        if ($handling){
            unset($rules['aircraft_id']);
        }

        if (\request("manual_flt_no")) {
            $rules['flt_no'] = "required";
            $rules['departure_airport'] = "required";
            $rules['arrival_airport'] = "required";
        }
        else{
            $rules['flight_number_id'] = "required|exists:flights__numbers,id";
        }

        if (\request("manual_operator")) {
            $rules['operator_name'] = "required";
        }


        return $this->isValid($rules);
    }

    /**
     * Validate input data before update exists flight
     * @param bool|false $handling
     * @return mixed
     */
    public function isValidForEdit($handling = false)
    {
        $rules = [
            "flight_id"        => "required|exists:flights,id",
            "std"              => "nullable|date_format:\"Y-m-d H:i\"",
            "ptd"              => "nullable|date_format:\"Y-m-d H:i\"",
            "etd"              => "nullable|date_format:\"Y-m-d H:i\"",
            "atd"              => "nullable|date_format:\"Y-m-d H:i\"",
            "abn"              => "nullable|date_format:\"Y-m-d H:i\"",
            "sta"              => "nullable|date_format:\"Y-m-d H:i\"",
            "pta"              => "nullable|date_format:\"Y-m-d H:i\"",
            "eta"              => "nullable|date_format:\"Y-m-d H:i\"",
            "ata"              => "nullable|date_format:\"Y-m-d H:i\"",
            "pax_c_actual"     => "nullable|integer",
            "pax_y_actual"     => "nullable|integer",
            "pax_inf_actual"   => "nullable|integer",
            "baggage"          => "nullable|integer",
            "cargo"            => "nullable|integer",
            "mail"             => "nullable|integer",
            "deportees"        => "nullable|integer",
            "in_tanks"         => "nullable|numeric",
            "uplifted"         => "nullable|numeric",
            "utilised"         => "nullable|numeric"
        ];

        if ($handling){
            unset($rules['aircraft_id']);
        }

        /*
        if (\request("is_diversion") && !\request("diverted_flight"))
        {
            $rules["diversion_airport"] = "required|exists:airports,id";
            $rules["diversion_sta"]     = "required|date_format:\"Y-m-d H:i\"";
            $rules["diversion_std"]     = "required|date_format:\"Y-m-d H:i\"";
            $rules["diversion_eta"]     = "date_format:\"Y-m-d H:i\"";
            $rules["diversion_ata"]     = "date_format:\"Y-m-d H:i\"";
            $rules["diversion_etd"]     = "date_format:\"Y-m-d H:i\"";
            $rules["diversion_atd"]     = "date_format:\"Y-m-d H:i\"";
            $rules["diversion_abn"]     = "date_format:\"Y-m-d H:i\"";
        }
        */
        return $this->isValid($rules);
    }


    /**
     * Validate AJAX form data before update flight information
     * @return mixed
     */
    public function isValidForUpdateFlight()
    {
        $rules = [
            "start_date"    => "required|date_format:\"Y-m-d H:i:s\"",
            "end_date"      => "required|date_format:\"Y-m-d H:i:s\"",
            "flight_id"     => "required|exists:flights,id",
            "aircraft_name" => "required|exists:aircraft,name"
        ];
        return $this->isValid($rules);
    }
}
