<?php namespace App\Forms;
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 12.08.14

 */

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\MessageBag;

class BaseForm
{
    protected $passes;
    protected $errors;

    public function __construct()
    {
        $errors = new MessageBag();
        if ($old = request()->old("errors"))
        {
            $errors = $old;
        }
        $this->errors = $errors;
    }

    public function isValid($rules, $messages = array())
    {
        $validator = Validator::make(request()->all(), $rules, $messages);
        $this->passes = $validator->passes();
        $this->errors = $validator->errors();
        return $this->passes;
    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function setErrors(MessageBag $errors)
    {
        $this->errors = $errors;
        return $errors;
    }

    public function hasErrors()
    {
        return $this->errors->any();
    }

    public function getError($key)
    {
        return $this->getErrors()->first($key);
    }

    public function isPosted()
    {
        return request()->server("REQUEST_METHOD") == "POST";
    }

}
