<?php namespace App\Forms;


/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 21.08.14

 */
class AircraftForm extends BaseForm
{
    /**
     * Validate aircraft before save to DB
     * @return mixed
     */
    public function isValidAircraft()
    {
        return $this->isValid([
            "name"              => "required|min:3",
//            "aircraft_type_id"  => "required|exists:aircraft__types,id",
//            "config_c"          => "nullable|integer",
//            "config_y"          => "nullable|integer"
        ]);
    }

    /**
     * Validate aircraft edit form
     * @return mixed
     */
    public function isValidAircraftForEdit()
    {
        $maintenance_rules = [];
        if (\request("add_maintenance"))
        {
            // was attempt to add new maintenance
            $maintenance_rules = [
                "note"           => "required|min:3",
                "location_code"  => "required|min:3",
                "arrival_time"   => "required",
                "departure_time" => "required"
            ];
        }
        else if (\request("maintenance_id"))
        {
            // edit existing maintenance
            $maintenance_rules = [
                "note"           => "required|min:3",
                "location_code"  => "required|min:3",
                "arrival_time"   => "required",
                "departure_time" => "required",
                "maintenance_id" => "required|exists:aircrafts_maintenances,id"
            ];
        }

        return $this->isValid($maintenance_rules + [
                "name"              => "required|min:3",
//                "id"                => "required|exists:aircraft,id",
//                "aircraft_type_id"  => "required|exists:aircraft__types,id",
                "config_c"          => "nullable|integer",
                "config_y"          => "nullable|integer"
            ]);

    }

    /**
     * Validate aircraft type before save to DB
     * @return mixed
     */
    public function isValidType()
    {
        return $this->isValid([
            "name"    => "required|min:2",
        ]);
    }


    public function isValidMaintenanceRecord(){
        $rules = [];

        // edit existing maintenance
        $rules = [
            "id"                => 'required',
            "note"              => "required|min:3",
            "location_code"     => "required|min:3",
            "arrival_time"      => "required|date",
            "departure_time"    => "required|date",
        ];

        return $this->isValid($rules);
    }
}
