<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        if (env(APP_ENV) != PRODUCTION){
            return;
        }

        switch(env("AIRLINE")){
            // ACTIVE
            case GSRM:
                $schedule->command('parse:fetch_messages')->cron('*/5 * * * *');
                $schedule->command('parse:parse_messages')->cron('*/7 * * * *');

                // Also remove more than 3 days old Messages Result
                $schedule->command('flight_com:archive')->cron('0 0 * * *');
                $schedule->command('pax_details:removal')->cron('0 1 * * *');

                // Added on JAN8 2020
                // Match parent flight
                $schedule->command('match:parent_flights')->cron('0 2 * * *');
                $schedule->command('notification:send_email')->cron('30 2 * * *');
                $schedule->command('duplicate:fn')->cron('0 3 * * *');
                $schedule->command('remove:no_station')->cron('30 3 * * *');
//         		$schedule->command('inactivity:logout')->cron('*/10 * * * *');
                break;

            case DHS:
                $schedule->command('parse:fetch_messages')->cron('*/5 * * * *');
                $schedule->command('parse:parse_messages')->cron('*/3 * * * *');

                // Also remove more than 3 days old Messages Result
                $schedule->command('flight_com:archive')->cron('0 0 * * *');
                $schedule->command('pax_details:removal')->cron('0 1 * * *');

                // Added on JAN8 2020
                // Match parent flight
                $schedule->command('match:parent_flights')->cron('0 2 * * *');
                $schedule->command('notification:send_email')->cron('30 2 * * *');
                $schedule->command('duplicate:fn')->cron('0 3 * * *');
                $schedule->command('remove:no_station')->cron('30 3 * * *');
                break;

            case STATION:
            case GHA:
            case FRAAI:
            case IAG:
            case AVIAM:
            case SCO:
            case CAA:
            case KAPKG:
            case COASTAL:
            case AIRLINE:
                $schedule->command('parse:fetch_messages')->cron('*/15 * * * *');
                $schedule->command('parse:parse_messages')->cron('*/17 * * * *');
                break;
            // END ACTIVE

            case TAJIK_AIR:
                $schedule->command('parse:fetch_messages')->cron('*/11 * * * *');
                $schedule->command('parse:parse_messages')->cron('*/13 * * * *');
                $schedule->command('sirena:xml')->cron('0 */1 * * *');
                $schedule->command('match:pnl_and_prl')->cron('0 */1 * * *');
                break;

        }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
