<?php

namespace App\Console\Commands;

use App\Models\CommandResult;
use App\Models\Session;
use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class UserInactivityLogout extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'inactivity:logout';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    protected $commandName = "User Inactivity Logout";

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @return int
     * @throws \Exception
     */
    public function handle()
    {
        $command = new CommandResult();
        $command->command_name = $this->commandName;
        $command->status = PENDING;
        $command->found_emails = 0;
        $command->created_at = date("Y-m-d H:i:s");
        $command->save();

        $sessions = Session::groupBy("user_id")
            ->get([
                "user_id",
                DB::raw("MAX(last_activity) as last_activity")
            ])
            ->toArray();

        $time = time();
        $logoutUserIDs = [];
        // Logout after 2 hrs of inactivity
        foreach ($sessions as $session) {
            if ($time - $session["last_activity"] > 7200){
                $logoutUserIDs[] = $session["user_id"];
            }
        }

        if (count($logoutUserIDs)) {
            User::whereIn("id", $logoutUserIDs)->update([
                "remember_token" => null
            ]);
            Session::whereIn("user_id", $logoutUserIDs)->delete();

            $command->found_emails = count($logoutUserIDs);
        }

        $command->status = COMPLETED;
        $command->completed_at = date("Y-m-d H:i:s");
        $command->save();

        return 1;
    }
}
