<?php

namespace App\Console\Commands;

use App\Models\Flight;
use App\Models\FlightNumber;
use Illuminate\Console\Command;

class RemoveFlightsWithNoStationCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'remove:no_station';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $flightNumbersIDs = FlightNumber::where(function($sql){
            $sql->whereNull("departure_airport_id")
                ->orWhereNull("arrival_airport_id");
        })
            ->whereNull("deleted_at")
            ->get(["id"])
            ->pluck("id")
            ->all();

        $period48 = date("Y-m-d H:i:s", strtotime("- 2 days"));
        $period3Days = date("Y-m-d", strtotime("- 3 days"));

//        $handlingAPs = Airport::listHandlingStations("id");

        $flights = Flight::
//                        join("flights__numbers", "flights__numbers.id", "=", "flights.flight_number_id")
//                        ->where(function($sql) use ($handlingAPs){
//                            $sql->whereIn("flights__numbers.departure_airport_id", $handlingAPs)
//                                ->orWhereIn("flights__numbers.arrival_airport_id", $handlingAPs);
//                        })
        whereIn("flight_number_id", $flightNumbersIDs)
            ->whereNull("flights.deleted_at")
            ->whereNull("flights.cancelled_at")
            ->where(function($sql) use ($period48){
                $sql->where("std", "<", $period48)
                    ->orWhere("ptd", "<", $period48)
                    ->orWhere("atd", "<", $period48);

            })
            ->get([
                "flights.id", "std", "sta",  "ptd", "pta", "flights.deleted_at", "flight_number_id"
            ]);


        debug($flightNumbersIDs);
        debug($flights);

        $now = date("Y-m-d H:i:s");
        $excludeFNs = [];
        foreach ($flights as $flight) {
            $otherFlts = Flight::where("flight_number_id", $flight->flight_number_id)
                ->whereNull("deleted_at")
//                ->whereNull("cancelled_at")
                ->where("departure_date", ">=", $period3Days)
//                ->where(function($sql) use ($period48){
//                    $sql->where("std", ">", $period48)
//                        ->orWhere("ptd", ">", $period48)
//                        ->orWhere("atd", ">", $period48);
//                })
                ->first(["id"]);

            $flight->deleted_at = $now;
            $flight->save();

            if ($otherFlts){
                $excludeFNs[] = $flight->flight_number_id;
            }
        }

        debug($excludeFNs);
        $otherFNs = array_diff($flightNumbersIDs, $excludeFNs);
        debug("Other FNs:");
        debug($otherFNs);

        FlightNumber::whereIn("id", $otherFNs)
            ->update([
                "deleted_at" => $now
            ]);

        return 0;
    }
}
