<?php

namespace App\Console\Commands;

use App\Models\FlightNumber;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RemoveDuplicateFNCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'duplicate:fn';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $result = FlightNumber::select([
            "flight_number", "airline_id", "departure_airport_id", "arrival_airport_id"
        ])
            ->whereNull("deleted_at")
            ->groupBy([
                "flight_number", "airline_id", "departure_airport_id", "arrival_airport_id"
            ])
            ->having(DB::raw("COUNT(*)"), ">", 1)
            ->get();

        foreach ($result as $i => $item) {
            removeFlightNumberDuplications($item->flight_number, $item->airline_id, $item->departure_airport_id, $item->arrival_airport_id);
            if ($i > 10){
                break;
            }
        }

        return 0;
    }
}
