<?php

namespace App\Console\Commands;

use App\Models\CommandResult;
use App\Models\Passenger;
use App\Models\PassengerFlight;
use App\Models\PassengerFlightAct;
use App\Models\PassengerOrder;
use App\Models\PNLMessage;
use App\Models\PRLMessage;
use App\Models\ResultMessage;
use Illuminate\Console\Command;

class PaxDetailsRemovalCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pax_details:removal';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    public function __construct()
    {
        parent::__construct();
    }

    const MAX_EXECUTION_TIME = 120;

    /**
     * @throws \Exception
     */
    public function handle()
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

        $this->initiateCommand();

        $priorTo60Days = date("Y-m-d H:i:s", strtotime("- 55 days"));

        Passenger::where("created_at", "<=", $priorTo60Days)
                ->delete();

        PassengerFlight::whereNull("passenger_id")
                ->delete();

//        $paxIDs = Passenger::pluck("id")->all();
//        PassengerFlightAct::whereNotIn("passenger_id", $paxIDs)
//                        ->delete();
//        $paxOrderIDs = PassengerFlight::select("passenger_order_id")->whereNotNull("passenger_order_id")->distinct()->pluck("passenger_order_id")->all();
//        $paxActOrderIDs = PassengerFlightAct::select("passenger_order_id")->whereNotNull("passenger_order_id")->distinct()->pluck("passenger_order_id")->all();
//        $orderIDs = array_unique(array_merge($paxOrderIDs, $paxActOrderIDs));
//        PassengerOrder::whereNotIn("id", $orderIDs)->delete();

        PassengerFlight::where("created_at", "<=", $priorTo60Days)
                        ->delete();

        PassengerFlightAct::where("created_at", "<=", $priorTo60Days)
                        ->delete();

        PassengerOrder::where("created_at", "<=", $priorTo60Days)
                        ->delete();

        PRLMessage::where("created_at", "<=", $priorTo60Days)
                    ->delete();

        PNLMessage::where("created_at", "<=", $priorTo60Days)
                    ->delete();

        $priorTo14Days = date("Y-m-d H:i:s", strtotime("- 14 days"));

        ResultMessage::where("created_at", "<=", $priorTo14Days)
            ->delete();

        $this->completeCommand();

        return 0;
    }

    protected $currentCommand;
    protected $commandName = "PaxDetailsRemovalCommand";

    function initiateCommand(){
        $this->currentCommand = new CommandResult();
        $this->currentCommand->status = PENDING;
        $this->currentCommand->command_name = $this->commandName;
        $this->currentCommand->save();
    }

    public function completeCommand(){
        $this->currentCommand->status = COMPLETED;
        $this->currentCommand->completed_at = date("Y-m-d H:i:s");
        $this->currentCommand->save();
    }
}
