<?php

namespace App\Console\Commands;

use App\Classes\Parsing\ParseMessagesOperations;
use App\Models\Airport;
use App\Models\CommandError;
use App\Models\CommandResult;
use App\Models\Country;
use Illuminate\Console\Command;

class ParseMessagesCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'parse:parse_messages';

    const MAX_EXECUTION_TIME = 120;

    protected $commandName = PARSE_EMAIL_MESSAGES;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    protected $ghaModule;

    protected $fullParsing = false;

    /**
     *
     */
    public function __construct()
    {
        parent::__construct();

        $this->ghaModule = ghaModule();

        /// Enable Full parsing for DHS
        $this->fullParsing = env(AIRLINE) == DHS;

        $this->setVariableIds();

        $this->setTypes();
    }

    protected $messageLog = [];
    protected $countryIDs = [];
    protected $countryISOIDs = [];
    protected $airportIDs = [];

    protected $types = [];

    protected $prevCommand;
    protected $currentCommand;

    protected $totalMessages;
    protected $parsedMessages;

    protected $parseOperations;
    protected $limit;


    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if ($this->commandRunning()){
            return;
        }

        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
        ini_set('memory_limit', '256M');

//        $this->limit = date("Y-m-d H:i:s", strtotime("- 12 hours"));
        $this->limit = date("Y-m-d H:i:s", strtotime("- 30 minutes"));

        // Initiate
        $this->initiateCommand();

        $this->parseOperations = new ParseMessagesOperations(null, $this->airportIDs, $this->countryIDs);

        $this->totalMessages = 0;
        $this->parsedMessages = 0;

//        $this->debug();

        $this->start();

        $this->completeCommand();

        return 0;
    }

    function debug(){
        $list = [
            MVT                 => FULL_PARSING,
        ];

        foreach ($list as $type => $parsingType) {
            $this->initiateParse($type, $parsingType);
        }
    }

    function start(){
        foreach ($this->types as $i => $list) {

            if ($i == 1){
                // Others Types -> No looping
                $this->initiateParse(OTHS);
            }
            else {
                foreach ($list as $type => $parsingType) {
                    $this->initiateParse($type, $parsingType);
                }
            }
        }
    }

    function initiateParse($type, $partialParsing = null){
        try {
            $parsingResult = $this->parseOperations->preRun($type, $this->limit, $partialParsing);
            $this->setResults($parsingResult);
        }
        catch(\Exception $e){
            $this->reportError($e, "Parse Emails");
        }
    }

    function setResults($parsingResult){
        if ($parsingResult){
            if ($parsingResult["parsed"]){
                $this->parsedMessages += $parsingResult["parsed"];
            }
            if ($parsingResult["total"]){
                $this->totalMessages += $parsingResult["total"];
            }
        }
    }

    function setTypes(){

        $this->types = [
            0 => [
                // Flight
                MVT                 => FULL_PARSING,
                LDM                 => FULL_PARSING,
                LPM                 => FULL_PARSING,
                SLS                 => FULL_PARSING,
                HBG                 => FULL_PARSING,
                LIR                 => FULL_PARSING,
                CAL                 => FULL_PARSING,
                PAL                 => FULL_PARSING,
                CREW_LIST           => FULL_PARSING,
            ],
            1 => [
                // Others types
                LOADSHEET           => FULL_PARSING,
                LOADSHEET_FINAL     => FULL_PARSING,
                FAG                 => FULL_PARSING,
                ONLOAD              => FULL_PARSING,
                NOT                 => FULL_PARSING,
                NOTOC               => FULL_PARSING,
                COMRO               => FULL_PARSING,
                COM                 => FULL_PARSING,
                WAB                 => FULL_PARSING,
                TXT_ING             => FULL_PARSING,
            ],
            2 => [
                // Baggage
                CPM                 => FULL_PARSING, // $this->ghaModule ? PARTIAL_PARSING : FULL_PARSING,
                UCM                 => FULL_PARSING, // $this->ghaModule ? PARTIAL_PARSING : FULL_PARSING,
            ],
            3 => [
                // PAX
                PSM                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
                TPM                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
                PTM                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
                PNL                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
                PRL                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
                ADL                 => $this->fullParsing ? FULL_PARSING : PARTIAL_PARSING,
            ]
        ];
    }

    function setVariableIds(){
        $this->countryIDs = Country::whereNotNull("abbr")->pluck("id", "abbr")->all();
        $this->countryISOIDs = Country::whereNotNull("iso_alpha_3")->pluck("id", "iso_alpha_3")->all();
        $this->airportIDs = Airport::whereNotNull("iata")->pluck("id", "iata")->all();
    }

    function reportError(\Exception $e, $type = null){
        $error = new CommandError();
        $error->command_id = $this->currentCommand ? $this->currentCommand->id : null;
        //$error->data = $data ? json_encode($data) : null;
        $error->type = $type;
        $error->code = $e->getCode();
        $error->file = $e->getFile();
        $error->line = $e->getLine();
        $error->message = $e->getMessage();
        $error->save();
    }

    public function commandRunning(){

        $limit = date("Y-m-d H:i:s", strtotime("- 30 minutes"));

        $this->prevCommand = CommandResult::where("status", PENDING)
            ->where("created_at", ">", $limit)
            ->where("command_name", $this->commandName)
            ->whereNull("completed_at")
            ->first();

        return $this->prevCommand != null;
    }

    public function initiateCommand(){
        $this->currentCommand = new CommandResult();
        $this->currentCommand->status = PENDING;
        $this->currentCommand->command_name = $this->commandName;
        $this->currentCommand->save();

    }

    public function completeCommand(){
        $this->currentCommand->status = COMPLETED;
        $this->currentCommand->completed_at = date("Y-m-d H:i:s");

        $this->currentCommand->found_emails = isset($this->totalMessages) ? $this->totalMessages : null;
        $this->currentCommand->email_parsed = isset($this->parsedMessages) ? $this->parsedMessages : null;

        $this->currentCommand->save();
    }
}
