<?php

namespace App\Console\Commands;

use App\Classes\BindFlights\FlightPosition;
use App\Models\Flight;
use Illuminate\Console\Command;

class MatchParentFlightsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'match:parent_flights {--date=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Match parent flight with child flight';

    protected $airlineIDs = [];
    protected $log = [];
    protected $emailNotificationRecipients = [
        "dilovar88@mail.ru"  => "Dilovar Tursunov"
    ];
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $result = [];

//        $date = "2023-04-19";
//        $result[$date] = $this->init($date);
//        debug($result);
//        return 1;
        if ($this->option("date")){
            $this->init($this->option("date"));
        }
        else {
            for ($i = 0; $i <= 30; $i++) {
                if ($i == 0) {
                    $date = date("Y-m-d");
                } else {
                    $date = date("Y-m-d", strtotime(" + {$i} days"));
                }
                $result[$date] = $this->init($date);
            }

            // 7. Send Log email to developer
            /*
            try {
                foreach ($this->emailNotificationRecipients as $recipientEmail => $recipientName) {
                    Mail::to($recipientEmail)
//                ->bcc("dilovar88@mail.ru")
                        ->send(new TemplateEmail(print_r($this->log, TRUE), "Parent Matching LOG/GSRM"));
                }
            } catch (\Exception $e) {
                debug($e->getMessage());
                return "ERROR";
            }
            */
        }

        return 0;
    }

    function init($date){
        $startDate = date("Y-m-d H:i:s", strtotime("-9 hours", strtotime($date." 00:00:00")));
        $endDate   = $date." 23:59:59";

        $flights =  Flight::handlingFlightsRange($startDate, $endDate);

        $flightPosition = new FlightPosition($flights);
        $flightPosition->strict = true;
        $flightPosition->date = $date;
        $flightPosition->run();

        $i = $m = 0;
        $result = [
            "matched"     => [],
            "unmatched"   => [],
        ];

        debug("LINES: " .count($flightPosition->lines));

        foreach ($flightPosition->lines as $k => $line){
            $items = $line->getFlights();

            if(!$items || !count($items) || count($items) > 2){
                debug($items);
            }

            try {
                if (count($items) == 2) {
                    $arrFlight = $items[0];
                    $depFlight = $items[1];

                    if ($arrFlight && $depFlight) {
                        $msg = "Matched | ". $date." | ".
                            getFlightNumberFull($arrFlight->flightNumber) . " - " . getFlightNumberFull($depFlight->flightNumber)
                            . "(" . $arrFlight->id . "-" . $depFlight->id . ")";

                        unset($depFlight->type);
                        unset($depFlight->dep_date);
                        unset($depFlight->dep_datetime);
                        unset($depFlight->arr_date);
                        unset($depFlight->arr_datetime);

                        $depFlight->parent_id = $arrFlight->id;
                        $depFlight->save();

                        $result["matched"][] = $msg;
                        $this->log[] = $msg;

                        $i++;
                    }
                    else {
                        debug($items);
                    }
                }
                else {
                    if (count($items) == 1) {
                        $flight = $items[0];

                        $msg = "Unmatched | ". $date." | ".
                            getFlightNumberFull($flight->flightNumber) . " (" . $flight->id . ")";

                        $result["unmatched"][] = $msg;

                        $this->log[] = $msg;

                        $m++;
                    }
                    else {
                        debug($items);
                    }
                }
            }
            catch (\Exception $e){
                debug($e->getMessage());
                debug($items);
            }
        }

        return $result;
    }
}
