<?php

namespace App\Console\Commands;

use App\Mail\TemplateEmail;
use App\Models\FlightOrderStatus;
use App\Models\PassengerFlight;
use App\Models\PassengerFlightAct;
use Illuminate\Console\Command;

use Illuminate\Support\Facades\Mail;

class MatchPNLandPRL extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'match:pnl_and_prl';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        if (\request("from") && \request("to")){
            $this->from = \request("from");
            $this->to = \request("to");
        }
        else {
            $this->from = date("Y-m-d", strtotime("- 1 day"));
            $this->to = date("Y-m-d", strtotime("- 1 day"));
        }

        $this->from .= " 00:00:00";
        $this->to   .= " 23:59:59";

        $this->getFlownStatusID();

        // Get Period PRLs
        $this->getPRLs();

        // Match
        $this->matchRecords();

        $this->sendNotification();

        return 0;
    }

    function getFlownStatusID(){
        $status = FlightOrderStatus::where("order_status", "F")
            ->first();

        $this->flownStatusID = $status->id;
    }

    function getPRLs(){
        $this->prlList = PassengerFlightAct::getActList($this->from, $this->to);
    }

    function matchRecords(){
        foreach ($this->prlList as &$each) {
            $pnl = PassengerFlight::where("passenger_id", $each->passenger_id)
                ->where(function($sql) use ($each){
                    $sql->where(function($sql1) use ($each){
                        $sql1->where("flight_id", $each->flight_id)
                            ->orWhere(function($sql2) use ($each){
                                $sql2->where("flight_number_id", $each->flight_number_id)
                                    ->where("departure_date", $each->departure_date);
                            });
                    })
                        ->orWhere(function($sql1) use ($each){
                            $sql1->where("passenger_order_id", $each->passenger_order_id)
                                ->where("coupon", $each->coupon);
                        });
                })

                ->get();

            if ($pnl->count() == 0){
                debug("No Match! PRL: {$each->departure} / {$each->flightNumber->flight_number}");
                continue;
            }

            if ($pnl->count() > 1){
                $ids = "";
                foreach ($pnl as $item) {
                    $ids .= $item->id.", ";
                }
                $ids = rtrim($ids, ", ");

                debug("FOUND Multiple PNLs({$pnl->count()}) IDS: { $ids}. PRL: {$each->departure} / {$each->flightNumber->flight_number}");
            }
            else {
                $foundPNL = $pnl->first();
                $each->passenger_flight_id = $foundPNL->id;
                $each->flight_order_status_id = $this->flownStatusID;
                $each->save();
            }
        }
    }

    function sendNotification(){
        // 7. Send Log email to developer
        foreach ($this->emailNotificationRecipients as $recipientEmail => $recipientName)
        {
            Mail::to($recipientEmail)
//                    ->bcc("dilovar88@mail.ru")
                ->send(new TemplateEmail("Bind Flights Process Successfully Done.", "Bind Flights Command"));
        }
    }
}
