<?php

namespace App\Console\Commands;

use App\Models\CommandResult;
use App\Models\FlightCom;
use App\Models\FlightComDetails;
use App\Models\FlightComDetailsArchive;
use App\Models\FlightComUserViews;
use App\Models\FlightComUserViewsArchive;
use Illuminate\Console\Command;

class FlightComArchiveMessages extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'flight_com:archive';

    const MAX_EXECUTION_TIME = 600;

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     *
     */
    public function __construct()
    {
        parent::__construct();
    }

    protected $comCount;

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ini_set("max_execution_time", self::MAX_EXECUTION_TIME);

        ini_set('memory_limit', '1048M');

        $priorTo2Days = date("Y-m-d", strtotime("- 2 days"));

        // Select Flight Coms
        $flightComIDs = FlightCom::join("flights", "flights.id", "=", "flights__com.flight_id")
            ->where(function($sql) use ($priorTo2Days){
                $sql->where("flights.atd", "<", $priorTo2Days)
                    ->orWhere("flights.ptd", "<", $priorTo2Days)
                    ->orWhere("flights.std", "<", $priorTo2Days);
            })
            //where("created_at", "<", $priorTo2Days)
            ->whereNull("archived")
            ->pluck("flights__com.id")
            ->all();

        $this->comCount = count($flightComIDs);

        if (!$this->comCount){
            return;
        }

        $this->initiateCommand();

//        try {
            $this->archiveDetails($flightComIDs);
//        }
//        catch(\Exception $e){
//            debug("Details Errors: " . $e->getMessage());
//        }

//        return 1;

//        try {
            $this->archiveUserViews($flightComIDs);
//        }
//        catch(\Exception $e){
//            debug("User Views Errors: " . $e->getMessage());
//        }

//        return 1;

        // Set archived
        FlightCom::whereIn("id", $flightComIDs)->update([
            "archived"  => true
        ]);

        $this->completeCommand();

        return 0;
    }

    protected $currentCommand;
    protected $commandName = "FlightComArchiveMessages";

    function initiateCommand(){
        $this->currentCommand = new CommandResult();
        $this->currentCommand->status = PENDING;
        $this->currentCommand->command_name = $this->commandName;
        $this->currentCommand->save();
    }

    public function completeCommand(){
        $this->currentCommand->status = COMPLETED;
        $this->currentCommand->found_emails = $this->comCount;
        $this->currentCommand->email_parsed = $this->detailsCount;
        $this->currentCommand->email_exists = $this->userViewsCount;

        $this->currentCommand->completed_at = date("Y-m-d H:i:s");
        $this->currentCommand->save();
    }

    protected $detailsCount;

    function archiveDetails($flightComIDs){
        $details = FlightComDetails::whereIn("flight_com_id", $flightComIDs)
            ->get([
                "id AS flight_com_details_id",
                "flight_com_id",
                "message",
                "enc",
                "created_by",
                "updated_by",
                "created_at",
                "updated_at",
                "deleted_at",
            ]);

        $detailsArray = $details->toArray();

        $this->detailsCount = count($detailsArray);

        for($i = 0; $i < count($detailsArray); $i += 2000){
            $sliced = array_slice($detailsArray, $i, 2000);

            $this->updateDates($sliced);

//            debug($sliced);
//            return 1;

            // Insert
            FlightComDetailsArchive::insert($sliced);
        }

        // Remove prev
        FlightComDetails::whereIn("flight_com_id", $flightComIDs)->delete();
    }

    function updateDates(&$arr){
        foreach ($arr as &$each){

            if (isset($each["created_at"])) {
                $each["created_at"] = date("Y-m-d H:i:s", strtotime($each["created_at"]));
            }

            if (isset($each["updated_at"])){
                $each["updated_at"] = date("Y-m-d H:i:s", strtotime($each["updated_at"]));
            }

            if (isset($each["deleted_at"])){
                $each["deleted_at"] = date("Y-m-d H:i:s", strtotime($each["deleted_at"]));
            }
        }
    }

    protected $userViewsCount;

    function archiveUserViews($flightComIDs){

        $userViews = FlightComUserViews::whereIn("flight_com_id", $flightComIDs)
            ->get([
                "flight_com_id",
                "flight_com_details_id",
                "user_id",
                "created_at",
                "updated_at",
            ]);

        $userViewsArray = $userViews->toArray();

        $this->userViewsCount = count($userViewsArray);

        for($i = 0; $i < count($userViewsArray); $i += 2000){
            $sliced = array_slice($userViewsArray, $i, 2000);

            $this->updateDates($sliced);

//            debug($sliced);
//            return 1;

            // Insert
            FlightComUserViewsArchive::insert($sliced);
        }

        // Remove prev
        FlightComUserViews::whereIn("flight_com_id", $flightComIDs)->delete();
    }
}
