<?php

namespace App\Console\Commands;

use App\Classes\Parsing\FetchMessagesOperations;
use App\Classes\Parsing\ParseEmail;
use App\Mail\TemplateEmail;
use App\Models\CommandError;
use App\Models\CommandResult;
use App\Models\ResultMessage;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Mail;

class FetchEmailMessagesCommand extends Command
{
    /**
     * The console command name.
     * @var string
     */
    protected $name = "parse:fetch_messages";
    protected $local = 18000;

    protected $commandName = FETCH_EMAIL_MESSAGES;
    /**
     * The console command description.
     * @var string
     */
    protected $description = "Parse MVT emails and insert data to Database.";
    protected $emails = [];
    protected $stream;
    protected $mailbox;
    protected $emailId;
    protected $emailSubject = null;
    protected $emailBody;

    protected $senderEmail;
    protected $sentDate;
    protected $mvtType;
    protected $adlAction;
    protected $messageId;
    protected $udate;
    protected $messageLog = [];

    protected $limitEmails = 1000;
    protected $skipEmails = 0;
    protected $messages = [];
    protected $errors = [];
    protected $emailNotificationRecipients = [
        "dilovar88@mail.ru"  => "Dilovar Tursunov"
    ];

    const MAX_EXECUTION_TIME = 120;
    const MAX_EXECUTION_TIME_EXTENDED = 600;

    const MVT_DEPARTURE = "departure";
    const MVT_ARRIVAL = "arrival";

    const DEL = "DEL";
    const CHG = "CHG";
    const ADD = "ADD";

    protected $emailBoxes = [
//        "gsrm1xh",
//        "mucox",
//        "mucki",
//        "hamki",
//        "duski",
//        "fraki",
    ];

    protected $prevCommand;
    protected $currentCommand;

    protected $emailParsed = 0;
    protected $emailExists = 0;
    protected $emailNotMatched = 0;

    protected $currentTimezone;

    public function __construct()
    {
        parent::__construct();
    }

    protected $appAirline;


    /**
     * @throws \Exception
     */
    public function handle()
    {


        $this->appAirline = env(AIRLINE);

        switch($this->appAirline){
            case TAJIK_AIR:
                // date_default_timezone_set("UTC");
                // date_default_timezone_set("Asia/Dushanbe");
//                $this->currentTimezone = "America/Los_Angeles";
                $this->emailBoxes = ["tajikair"];
                break;

            case IAG:
                $this->emailBoxes = ["iag"];
                break;

            case SCO:
                $this->emailBoxes = ["sco"];
                break;

            case AVIAM:
                $this->emailBoxes = ["aviam"];
                break;

            case GSRM:
            case FRAAI:
                $this->emailBoxes = ["gsrm1xh"];
                $this->currentTimezone = "Europe/Berlin";
                break;

            case DHS:
                $this->emailBoxes = ["dhs"];
                $this->currentTimezone = "Europe/Berlin";
                break;

            // DEMO
            case AIRLINE:
            case COASTAL:
                $this->emailBoxes = ["airline"];
                break;

            case KAPKG:
                $this->emailBoxes = ["skykg"];
                break;

            case STATION:
                $this->emailBoxes = ["station"];
                break;
            case CAA:
                $this->emailBoxes = ["caa"];
                break;
            case GHA:
                $this->emailBoxes = ["gha"];
                break;

        }

        $now = date("Y-m-d H:i");

        $date = new \DateTime();
        if ($this->currentTimezone){
            $date->setTimezone(new \DateTimeZone($this->currentTimezone));
            //date_default_timezone_set($this->currentTimezone);
        }

        if ($this->commandRunning()){
            return;
        }

        switch($this->appAirline){
//            case TAJIK_AIR:
//            case CAA:
//            case AIRLINE:
//                ini_set("max_execution_time", self::MAX_EXECUTION_TIME_EXTENDED);
//                ini_set('memory_limit', '1024M');
//                break;

            default:
                ini_set("max_execution_time", self::MAX_EXECUTION_TIME);
                ini_set('memory_limit', '256M');
                break;
        }

        // Initiate
        $this->initiateCommand();

//        $this->skipEmails = \request("skip") ? \request("skip") : 0;

//        $this->limitEmails = \request("limit") ? \request("limit") : 90;

//        Parse::sendEmailNotification(env("AIRLINE"), "TEST");

        foreach ($this->emailBoxes as $each) {

            try {
                // 1. Open IMAP connection
                $this->openIMAPConnection($each);

            }
            catch(\Exception $e) {
                $this->reportError($e, "Open IMAP");
                debug($e->getMessage());
            }

            try {
                // 2. Get all UNREAD emails
                $this->emails = $this->getListOfUnreadEmails();
            }
            catch(\Exception $e){
                $this->reportError($e, "Get Emails List");
                debug($e->getMessage());
            }

            // 3. Parse all unread emails
            try {
                $this->fetchAllUnreadEmails();
            }
            catch(\Exception $e){
                $this->reportError($e, "Parse All Emails");
                debug($e->getMessage());
            }
//                $this->sendEmailNotification();

//                $this->debugOutput();
        }

        // Complete
        $this->completeCommand();

        return 0;
    }

    function reportError(\Exception $e, $type = null){
        $error = new CommandError();
        $error->command_id = $this->currentCommand ? $this->currentCommand->id : null;
        //$error->data = $data ? json_encode($data) : null;
        $error->type = $type;
        $error->code = $e->getCode();
        $error->file = $e->getFile();
        $error->line = $e->getLine();
        $error->message = $e->getMessage();
        $error->save();
    }

    public function commandRunning(){
        $limit = date("Y-m-d H:i:s", strtotime("- 20 minutes"));

        $this->prevCommand = CommandResult::where("status", PENDING)
            ->where("created_at", ">", $limit)
            ->where("command_name", $this->commandName)
            ->whereNull("completed_at")
            ->first();

        return $this->prevCommand != null;
    }

    public function initiateCommand(){
        $this->currentCommand = new CommandResult();
        $this->currentCommand->status = PENDING;
        $this->currentCommand->command_name = $this->commandName;
        $this->currentCommand->save();
    }

    public function completeCommand(){
        $foundEmails = $this->emails ? count($this->emails) : 0;
        $parsed = $foundEmails - ($this->emailExists ? $this->emailExists : 0);

        $this->currentCommand->status = COMPLETED;
        $this->currentCommand->completed_at = date("Y-m-d H:i:s");
        $this->currentCommand->found_emails = $foundEmails ? $foundEmails : null;

        $this->currentCommand->email_parsed = $parsed ? $parsed : null;
        $this->currentCommand->email_exists = $this->emailExists ? $this->emailExists : null;
        $this->currentCommand->email_not_matched = $this->emailNotMatched ? $this->emailNotMatched : null;

        $this->currentCommand->save();
    }

    /**
     * Open IMAP connection to work with mailbox
     * @param $account
     */
    private function openIMAPConnection($account)
    {
        $this->infoLog("open IMAP connection");
        $this->mailbox = Config::get("commands.{$account}");

        if (is_array($this->mailbox))
        {
            // Open an IMAP stream to our mailbox
            $this->stream = imap_open($this->mailbox["mailbox"], $this->mailbox["username"], $this->mailbox["password"]);

            if (!$this->stream)
            {
                debug("Stem return false");
                exit;
            }

            debug("Successfully connected");
            debug($this->stream);
        }
    }

    /**
     * @return array
     * @throws \Exception
     */
    private function getListOfUnreadEmails()
    {
        $date = new \DateTime();
//        $date = new \DateTime("2022-08-08");
//        $date = date("Y-m-d", strtotime("-1 days"));

        if ($this->currentTimezone){
            $date->setTimezone(new \DateTimeZone($this->currentTimezone));
        }

        $queryDate = $date->format("j F Y");
//        $queryDate = date("j F Y", strtotime("-1 days"));


        debug("Mailbox time: ". $queryDate);
        $this->infoLog("get list of unread emails");

        // Get ALL UNREAD messages
        $this->mc = imap_check($this->stream);

//        $emails   =  imap_search($this->stream, "ALL"); // "UNSEEN");
        $emails = imap_search($this->stream,'ON "'.$queryDate.'"' );


        if (!is_array($emails) || !count($emails))
        {
            debug("Not found any emails");

//            $queryDate = date("j F Y", strtotime("-2 days", strtotime($date->format("Y-m-d"))));
            $queryDate = date("j F Y", strtotime("-1 days", strtotime($date->format("Y-m-d"))));
            debug("Mailbox time: ". $queryDate);

            $this->infoLog("get list of unread emails");

            // Get ALL UNREAD messages
            $this->mc = imap_check($this->stream);

            $emails = imap_search($this->stream,'ON "'.$queryDate.'"' );

            if (!is_array($emails) || !count($emails)) {

                return [];
            }
        }

        debug($emails);

        $emails = array_reverse($emails);

        debug($emails);

        return $emails;
    }

    /**
     * Parse all UNREAD emails
     * @return void
     */
    private function fetchAllUnreadEmails()
    {
        $j = 0;

        debug("TIME NOW: ".date("Y-m-d H:i:s"));
        debug("TIME ZONE: ".date_default_timezone_get());

        if (is_array($this->emails) && count($this->emails))
        {
            $parseEmail = new ParseEmail($this->stream);
            $fetchOperations = new FetchMessagesOperations(null);
            $types = getMessageTypes();

            foreach ($this->emails as $emailId)
            {
                $j++;

                if ($j <= $this->skipEmails){
                    continue;
                }

                // Get Email Title
                $emailTitle = imap_headerinfo($this->stream, $emailId);

                try {
                    $this->emailSubject = property_exists($emailTitle, 'subject') ? $emailTitle->subject : null;
                }
                catch (\Exception $exception){
                    $this->emailSubject = null;
                }

                // Message ID
                $this->messageId = isset($emailTitle->message_id) ? $emailTitle->message_id : null;

                // or 2-fields as UNIQUE ID
                $this->udate = $emailTitle->udate;
                $this->senderEmail = $emailTitle->senderaddress;

                debug("UDATE: {$this->udate}");
                debug("SENDER: {$this->senderEmail}");
                debug($emailTitle);
//                return;

                // Check if email Exists
                if ($exists = ResultMessage::messageExists($this->messageId, $this->udate, $this->senderEmail)){
                    $this->emailExists++;
                    continue;
                }

                try {
                    if ($emailTitle) {
                        if ($this->currentTimezone){
                            $sentDate = new \DateTime($emailTitle->MailDate, new \DateTimeZone($this->currentTimezone));
                            $sentDate->setTimezone(new \DateTimeZone(UTC));
                            debug("Date C:" . $sentDate->format("Y-m-d H:i:s"));
                        }
                        else {
                            if (isset($emailTitle->date) && $emailTitle->date) {
                                $sentDate = new \DateTime($emailTitle->date);
                                debug("Date A:" . $sentDate->format("Y-m-d H:i:s"));
                            } else {
                                $sentDate = new \DateTime($emailTitle->MailDate);
                                debug("Date B:" . $sentDate->format("Y-m-d H:i:s"));
                            }
                        }

                        $this->sentDate = $sentDate->format("Y-m-d H:i:s");
//                        debug("EMAIL-Title SENT DATE: ". $this->sentDate);
//                        ." CONVERTED :". dateConvertToTimezone($this->sentDate, "America/Los_Angeles", "Y-m-d H:i:s", "UTC", "Y-m-d H:i:s"));
                    }
                    else {
                        $this->sentDate = date("Y-m-d H:i:s");
                        debug("AUTO SENT DATE A: ". $this->sentDate);
                    }
                }
                catch (\Exception $e){
                    $this->messageLog[] = $e->getMessage();
                    $this->sentDate = date("Y-m-d H:i:s");
                    debug($e->getMessage());
                    debug("AUTO SENT DATE B: ". $this->sentDate);
                }

                /*
                if ( strtotime($sentDate->format("Y-m-d")) <= strtotime(date("Y-m-d", strtotime("- 2 days")))){
                    continue;
                }
                */

                $this->emailId = $emailId;

                // get HTML email body text
                $emailBody = imap_body($this->stream, $emailId);

                // strip all HTML tags
                $emailBody = trim(strip_tags($emailBody));

                // remove HTML title text
                $emailBody = preg_replace('/(HTML\040+email)\s+/m', "", $emailBody);

                //1debug($emailBody);
                $emailBody = str_replace(["=0A", "=0a"], "\r\n", $emailBody);

                if ($this->appAirline == TAJIK_AIR){
                    $emailBody = str_replace(["=0D", "=0d"], "", $emailBody);
                }

                //2debug($emailBody);
                $emailBody = str_replace(["=\r\n", "= \r\n","=  \r\n", "=\n", "= \n", "=  \n"], "", $emailBody);

                // Added on SEP 3
                if ($this->appAirline != CAA){
                    $emailBody = preg_replace('/\s*(^--[\s\S]*Content-Type:.*charset=[\'"].*[\'"])\s*/m', "", $emailBody);
                }

                // This is for saving
                $this->emailBody = $emailBody;

                // Parse Email SET VARS
                $parseEmail->setVariables($this->emailId, $this->emailSubject, $this->emailBody, $this->sentDate, $this->senderEmail, $this->messageLog, $this->messageId, $this->udate);

                // Parse Operations SET VARS
                $fetchOperations->sentDate = $this->sentDate;

                try {
                    $fetchingResult = $fetchOperations->run($this->emailBody, $parseEmail);

                    if ($fetchingResult){
                        // Try with subject attached
                        if (isset($fetchingResult["foundMatch"]) && !$fetchingResult["foundMatch"]) {

                            preg_match('/^\s*('.implode("|", $types).')/m', $this->emailSubject, $subject);
                            if ($subject && isset($subject[1])){
                                $this->emailBody = $subject[1] . "\n". $this->emailBody;
//                                debug("Subject({$subject[1]}) was attached to body");
//                                debug($this->emailBody);

                                $parseEmail->setVariables($this->emailId, $this->emailSubject, $this->emailBody, $this->sentDate, $this->senderEmail, $this->messageLog, $this->messageId, $this->udate);
                                $fetchingResult = $fetchOperations->run($this->emailBody, $parseEmail);
                            }
                        }

                        if (isset($fetchingResult["exists"])){
                            $this->emailExists++;
                        }
                        if (isset($fetchingResult["foundMatch"]) && !$fetchingResult["foundMatch"]){
                            $this->emailNotMatched++;
                        }
                    }

                    // Save Result
                    ResultMessage::createMessage($this->messageId, $this->udate, $this->senderEmail, $fetchingResult["parsed"]);
                    //
                }
                catch(\Exception $e){
                    $this->reportError($e, "Parse Emails");
                }

                // Parse Operations RUN
                /*
                if ($j >= $this->limitEmails + $this->skipEmails){
                    break;
                }
                */
            }
        }
    }

    public function sendEmailNotification(){
        $totalMessage = array_merge(["MESSAGES-------------"], $this->messages, ["ERRORS-------------"], $this->errors);
        // 7. Send Log email to developer
        foreach ($this->emailNotificationRecipients as $recipientEmail => $recipientName)
        {
            Mail::to($recipientEmail)
//                ->bcc("dilovar88@mail.ru")
                ->send(new TemplateEmail(print_r($totalMessage, TRUE), "GSRM Email Parse Log"));
        }
    }

    public function debugOutput(){
        debug($this->messages);
        debug($this->errors);
    }

    public function infoLog($message){
        $this->messages[] = $message;
    }

    public function errorLog($message){
        $this->errors[] = $message;
    }
}
