<?php

namespace App\Console\Commands;

use App\Mail\TemplateEmail;
use App\Models\Flight;
use App\Models\FlightNumber;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class BindFlights extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bind:flights';
    protected $emailNotificationRecipients = [
        "dilovar88@mail.ru"  => "Dilovar Tursunov"
    ];

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $dateFrom = date("Y-01-01");
        $dateTo = date("Y-12-31");

        $flights = Flight::getParentFlights($dateFrom, $dateTo);

        foreach ($flights as $flight){
            if (is_numeric($flight->flight_number) && $flight->flight_number != '001'){
                $flight_num_inbound = FlightNumber::where('flight_number', intval($flight->flight_number + 1))
                    ->whereNull("deleted_at")
                    ->first();

                if (!empty($flight_num_inbound)){
                    $child = Flight::getChildFlight($flight_num_inbound->id, $flight->departure_date);

                    if (empty($child)){
                        if ($flight_num_inbound->flight_number != '202'){
                            $child = Flight::getChildFlight($flight_num_inbound->id, date('Y-m-d',strtotime("$flight->departure_date + 1 days")));

                            if (empty($child))
                                echo "Child Not found. PARENT = ".$flight->flight_number." | ".$flight->departure_date."<br/>";
                            else
                                Flight::where('id',$child->id)->first()->update(['parent_id'=>$flight->flight_id]);
                        }
                        else
                            echo "SZ 202 Not found. PARENT = ".$flight->flight_number." | ".$flight->departure_date."<br/>";
                    }
                    else {
                        Flight::where('id',$child->id)->first()->update(['parent_id'=>$flight->flight_id]);
                    }
                }
            }
        }

        // 7. Send Log email to developer
        foreach ($this->emailNotificationRecipients as $recipientEmail => $recipientName)
        {
            Mail::to($recipientEmail)
//                    ->bcc("dilovar88@mail.ru")
                ->send(new TemplateEmail("Bind Flights Process Successfully Done.", "Bind Flights Command"));
        }

        return 0;
    }
}
