<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 17.11.17

 */

namespace App\Classes\ULD;


use App\Models\Airport;
use App\Models\Flight;
use App\Models\FlightContainerInfo;
use App\Models\SCM;

class StockControl
{
    protected $handlingStations;

    protected $airline;
    protected $airport;
    protected $datetime;

    protected $containerInfo;

    protected $flights;
    protected $flightIDSs;

    protected $in = [];
    protected $out = [];

    /** @var ULD[] $uld  */
    protected $ULDs = [];

    public $stockULDs = [];
    public $stockULDsByType = [];

    public $SCM;
    public $scmDateTime;

    public $uldTypes;

    public function __construct($airline, $airport, $datetime = null){

        $this->airline = $airline;
        $this->airport = $airport;
        $this->datetime = $datetime ? $datetime : date("Y-m-d H:i:s");
    }

    public function setULDTypes($uldTypes){
        $this->uldTypes = $uldTypes;
    }

    public function process(){

        // Handling stations
        $this->handlingStations = Airport::getHandlingStationsIdAndObject();

        // Check for SCM
        $this->checkSCM();

        // Get Flights
        $this->flights = Flight::handlingFlightsRange($this->scmDateTime, $this->datetime, $this->airline, $this->airport);

        // Flights IDs
        $this->flightIDSs = $this->flights->pluck("id")->all();

        // Container Info
        $this->containerInfo = FlightContainerInfo::getAll($this->flightIDSs, $this->uldTypes);

        // Fill flights' ULDs'
        $this->fillULDs();

        $this->ULDs = array_values($this->ULDs);

        $this->setStockULDsByType();

    }

    public function checkSCM(){
        $this->SCM = SCM::with([
            "details",
            "details.container",
            "details.container.type",
            "details.info",
            "details.info.flight",
            "details.info.flight.flightNumber",
            "details.info.flight.flightNumber.departureAirport",
            "details.info.flight.flightNumber.arrivalAirport",
        ])
                    ->where("airline_id", $this->airline)
                    ->where("airport_id", $this->airport)
                    ->where("scm_datetime", "<=", $this->datetime)
                    ->whereNull("deleted_at")
                    ->orderBy("scm_datetime", "DESC")
                    ->first();

        if ($this->SCM){
            $this->scmDateTime = $this->SCM->scm_datetime;
        }
    }

    public function setStockULDsByType(){
        foreach ($this->ULDs as $each) {

            if (!$each->lastStatus || $each->lastStatus == ARRIVAL){
                $type = $each->container->type ? $each->container->type->name : "N/A";

                if (!isset($this->stockULDsByType[$type])){
                    $this->stockULDsByType[$type] = [];
                }

                $this->stockULDsByType[$type][] = $each;
            }
        }

        // Order
        foreach ($this->stockULDsByType as $type => $containers) {
            foreach ($containers as $each) {
                $this->stockULDs[] = $each;
            }
        }

    }

    /**
     * Fill ULDs
     */
    public function fillULDs(){

        // From SCM
        if ($this->SCM){
            foreach ($this->SCM->details as $detail) {

                // if Uld Type mentioned skip if not matched
                if ($this->uldTypes && !in_array($detail->container->container_type_id, $this->uldTypes)){
                    continue;
                }

                // If Info Exists
                $type = null;
                if ($detail->info){
                    $type = getFlightsDepArrType($detail->info->flight, $this->handlingStations);
                }

                // Manual Input
                $uld = $this->findCreateULD($detail->container);
                $uld->addContainerInfo($detail->info, $type);
            }
        }



        // From Flights
        foreach ($this->containerInfo as $each) {

            $type = getFlightsDepArrType($each->flight, $this->handlingStations);

            if (!$type || !count($each->flightContainer)){
                return;
            }

            foreach($each->flightContainer as $flightContainer){

                if (!$flightContainer->container_id ||
                    ($this->uldTypes && !in_array($flightContainer->container->container_type_id, $this->uldTypes)))
                {
                    continue;
                }

                $uld = $this->findCreateULD($flightContainer->container);
                $uld->addContainerInfo($each, $type);
            }
        }
    }

    public function addULD(){

    }

    /**
     * @param $uld
     * @return ULD
     */
    public function findCreateULD($uld){
        if (isset($this->ULDs[$uld->id])){
            return $this->ULDs[$uld->id];
        }
        else {
            $this->ULDs[$uld->id] = $newContainer = new ULD($uld);
            return $newContainer;
        }
    }
}
