<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 17.10.17

 */

namespace app\Classes\Transfer;


class TransferHelper
{
    public function sortAll(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareByAll"));
        }
    }

    public function sortByDate(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareByDate"));
        }
    }

    public function sortBySector(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareBySector"));
        }
    }

    public function sortByFlightNumber(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareByFlightNumber"));
        }
    }

    public function sortByOriginOrDestination(&$list){

        if ($list && count($list)) {
            usort($list, array($this, "compareByOriginOrDestination"));
        }
    }

    public function sortByCabin(&$list)
    {
        if ($list && count($list)) {
            usort($list, array($this, "compareByCabin"));
        }
    }

    /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareByAll($transferA, $transferB)
    {
        $comp = strcmp($transferA->getFlightNumber(), $transferB->getFlightNumber());

        if($comp === 0){

            $comp = strcmp($transferA->getTransferFN(), $transferB->getTransferFN());

            if ($comp === 0){

                $comp = strcmp($transferA->getCabin(), $transferB->getCabin());
            }
        }

        return $comp;
    }

    /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareByDate($transferA, $transferB)
    {
        return strcmp($transferA->getDepDate(), $transferB->getDepDate());
    }

    /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareByFlightNumber($transferA, $transferB)
    {
        return strcmp($transferA->getFlightNumber(), $transferB->getFlightNumber());
    }

     /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareBySector($transferA, $transferB)
    {
        return strcmp($transferA->getSector(), $transferB->getSector());
    }

    /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareByOriginOrDestination($transferA, $transferB)
    {
        return strcmp($transferA->getOriginOrDestination(), $transferB->getOriginOrDestination());
    }

    /**
     * @var ITransfer $transferA
     * @var ITransfer $transferB
     * @return int
     */
    function compareByCabin($transferA, $transferB)
    {
        return strcmp($transferA->getCabin(), $transferB->getCabin());
    }
}
