<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 17.10.17

 */

namespace App\Classes\Transfer;


class TransferHandler
{
    /** @var ITransfer[] */
    protected $transferList = [];

    protected $currentDepDate;
    protected $currentTransferType;

    protected $currentFN;
    protected $currentSector;
    protected $currentDepAirport;
    protected $currentArrAirport;

    protected $currentCabin;
    protected $currentTransferFN;
    protected $currentOrigin;
    protected $currentDestination;

    /** @var TransferHelper */
    protected $helper;

    public function __construct(){
        $this->helper = new TransferHelper();
    }

    public function getTransferList(){
        return $this->transferList;
    }

    public function sortAll(){
        $this->helper->sortAll($this->transferList);
    }

    public function AddInbound($depDate, $flightNumber, $depAirport, $arrAirport, $inboundFN, $origin, $rbd){
        $this->currentDepDate = $depDate;

        $this->currentTransferType = INBOUND;
        $this->currentFN = $flightNumber;
        $this->currentSector = $depAirport."-".$arrAirport;
        $this->currentDepAirport = $depAirport;
        $this->currentArrAirport = $arrAirport;

        $this->currentTransferFN = $inboundFN;
        $this->currentOrigin = $origin;

        $this->setCabin($rbd);

        $this->InboundProcess();
    }

    public function AddOutbound($depDate, $flightNumber, $depAirport, $arrAirport, $outboundFN, $destination, $rbd){
        $this->currentDepDate = $depDate;

        $this->currentTransferType = OUTBOUND;
        $this->currentFN = $flightNumber;
        $this->currentSector = $depAirport."-".$arrAirport;
        $this->currentDepAirport = $depAirport;
        $this->currentArrAirport = $arrAirport;

        $this->currentTransferFN = $outboundFN;
        $this->currentDestination = $destination;

        $this->setCabin($rbd);

        $this->OutboundProcess();
    }

    function setCabin($rbd){
        if (in_array($rbd, ["C", "D", "I", "J"])){
            $this->currentCabin = BUSINESS;
        }
        else {
            $this->currentCabin = ECONOMY;
        }
    }

    function InboundProcess(){
        $inbound = $this->findOrAddInboundTransfer();

        $inbound->addPAX();
    }

    function findOrAddInboundTransfer(){
        foreach ($this->transferList as &$each) {

            if (/*$each->getDepDate() == $this->currentDepDate*/
                    $each->getFlightNumber() == $this->currentFN
                        && $each->getTransferFN() == $this->currentTransferFN
                            && $each->getCabin() == $this->currentCabin){

                return $each;
            }
        }

        $inbound = new InboundTransfer($this->currentDepDate, $this->currentFN, $this->currentSector, $this->currentDepAirport, $this->currentArrAirport, $this->currentTransferFN, $this->currentOrigin, $this->currentCabin);

        $this->transferList[] = $inbound;

        return $inbound;
    }

    function OutboundProcess(){
        $outbound = $this->findOrAddOutboundTransfer();

        $outbound->addPAX();
    }

    function findOrAddOutboundTransfer(){
        foreach ($this->transferList as &$each) {

            if (/*$each->getDepDate() == $this->currentDepDate*/
                    $each->getFlightNumber() == $this->currentFN
                        && $each->getTransferFN() == $this->currentTransferFN
                            && $each->getCabin() == $this->currentCabin){

                return $each;
            }
        }

        $outbound = new OutboundTransfer($this->currentDepDate, $this->currentFN, $this->currentSector, $this->currentDepAirport, $this->currentArrAirport, $this->currentTransferFN, $this->currentDestination, $this->currentCabin);

        $this->transferList[] = $outbound;

        return $outbound;
    }
}
