<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 17.10.17

 */

namespace App\Classes\Transfer;


class OutboundTransfer extends Transfer implements ITransfer
{
    public function __construct($depDate, $flightNumber, $sector, $depAirport, $arrAirport, $transferFN, $destination, $cabin){

        $this->depDate = $depDate;
        $this->flightNumber = $flightNumber;
        $this->sector = $sector;
        $this->depAirport = $depAirport;
        $this->arrAirport = $arrAirport;

        $this->transferFN = $transferFN;
        $this->destination = $destination;
        $this->cabin = $cabin;
    }

    public function getType(){
        return "O/B";
    }

    public function getOriginOrDestination(){
        return $this->getDestination();
    }

    public function getTransferSector(){
        return $this->arrAirport."-".$this->destination;
    }
}
