<?php
/**
 * Created by PhpStorm.

 */

namespace App\Classes\Support;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Pagination\Paginator;

class PaginationFactory {

    public static function makeLengthAware(Builder $builder, $perPage = null, $columns = ['*'])
    {
        $page = Paginator::resolveCurrentPage();

        $builder->skip(($page - 1) * $perPage)->take($perPage + 1);

        $queryClone = clone ($builder->getQuery());

        $total = $queryClone->skip(0)->take($perPage + 1)->count($columns);

        return new LengthAwarePaginator($builder->get($columns), $total, $perPage, $page, [
            'path' => Paginator::resolveCurrentPath()
        ]);
    }




}
