<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 23.02.17

 */

namespace App\Classes\Staff\Report;

use App\Classes\Staff\Flight\StaffFlight;
use App\Models\FlightStaff;
use function GuzzleHttp\Psr7\str;

class StaffHours
{
    public $userId;
    public $userName;
    public $period;
    public $periodOption;
    public $salaryRate;

    public $service;
    public $serviceType;

    public $contracted;
    public $plannedGAP = [];
    public $actualGAP = [];

    public $shortHours = [];
    public $overtimeHours = [];
    public $actualShortOvertimeHours = [];

    // Planned
    public $pTotalHours = 0;
    public $pTotalTime = null;
    public $pTotalSalary = null;

    public $pTotalByPeriodHours = [];
    public $pTotalByPeriodTime  = [];
    public $pTotalSalaryByPeriod = [];

    // Actual
    public $totalHours = 0;
    public $totalTime = null;
    public $totalSalary = null;

    public $totalByPeriodHours = [];
    public $totalByPeriodTime  = [];
    public $totalSalaryByPeriod = [];

    public $user;

    public $pWorkingPeriods = [];
    public $workingPeriods = [];

    public $reason;
    public $reportTime;
    public $pReportTime;

    public $releaseTime;
    public $pReleaseTime;
    /**
     * @param $period
     * @param $periodOption
     * @param StaffFlight $staffFlight
     */
    public function __construct($period, $periodOption, $staffFlight = null){
        $this->period = $period;
        $this->periodOption = $periodOption;

        if ($staffFlight) {
            $this->contracted = $staffFlight->user->max_hours ? $staffFlight->user->max_hours : 0;
            $this->user = $staffFlight->user;
            $this->userId = $staffFlight->userId;
            $this->userName = $staffFlight->userName;
            $this->salaryRate = $this->getSalaryRate();

            $this->reason = $staffFlight->reason;

            $this->service = $staffFlight->service;
            $this->serviceType = $staffFlight->serviceType;
        }
    }


    public function getSalaryRate(){
        return $this->user && $this->user->salary_h ? $this->user->salary_h : 5;
    }

    public function setPlannedHours($selectedPeriod, $duration, $reportTime, $releaseTime){
        if (!$selectedPeriod){
            return;
        }

        $this->setPTotalHours($duration);

        $this->pReportTime = $reportTime;
        $this->pReleaseTime = $releaseTime;
        $this->setPWorkingPeriods($reportTime, $releaseTime);

        if (!isset($this->pTotalByPeriodHours[$selectedPeriod])){
            $this->pTotalByPeriodHours[$selectedPeriod] = 0;
        }

        $this->pTotalByPeriodHours[$selectedPeriod] = $this->pTotalHours;
    }

    public function setActualHours($selectedPeriod, $duration, $reportTime, $releaseTime){
        if (!$selectedPeriod){
            return;
        }

        $this->setTotalHours($duration);

        $this->reportTime = $reportTime;
        $this->releaseTime = $releaseTime;
        $this->setWorkingPeriods($reportTime, $releaseTime);

        if (!isset($this->totalByPeriodHours[$selectedPeriod])){
            $this->totalByPeriodHours[$selectedPeriod] = 0;
        }

        $this->totalByPeriodHours[$selectedPeriod] = $this->totalHours;
    }

    function setPWorkingPeriods($reportTime, $releaseTime){
        $index = $hourType = $value = null;

        foreach ($this->pWorkingPeriods as $i => $each) {
            $start = strtotime($each[0]);
            $end = strtotime($each[1]);

            if (strtotime($reportTime) >= $start && strtotime($reportTime) <= $end){

                $index = $i;
                $hourType = 1;
                $value = $each[0];
                // Pick the larger release time
                $releaseTime = strtotime($releaseTime) >= $end ? $releaseTime : $each[1];
                break;
            }
            else if (strtotime($releaseTime) >= $start && strtotime($releaseTime) <= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 2;
                break;
            }
            else if (strtotime($reportTime) <= $start && strtotime($releaseTime) >= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 3;
                break;
            }
        }

        if ($index || $index === 0) {
            if ($hourType == 1){
                $this->pWorkingPeriods[$index] = [ $value, $releaseTime ];
            }
            else if ($hourType == 2){
                $this->pWorkingPeriods[$index] = [ $reportTime, $value ];
            }
            else {
                $this->pWorkingPeriods[$index] = [ $reportTime, $releaseTime ];
            }
        }
        else {
            $this->pWorkingPeriods[] = [$reportTime, $releaseTime];
        }

//        $this->setPTotalHours();
    }

    function setWorkingPeriods($reportTime, $releaseTime){
        $index = $hourType = $value = null;

        foreach ($this->workingPeriods as $i => $each) {
            $start = strtotime($each[0]);
            $end = strtotime($each[1]);

            if (strtotime($reportTime) >= $start && strtotime($reportTime) <= $end){

                $index = $i;
                $hourType = 1;
                $value = $each[0];
                // Pick the larger release time
                $releaseTime = strtotime($releaseTime) >= $end ? $releaseTime : $each[1];
                break;
            }
            else if (strtotime($releaseTime) >= $start && strtotime($releaseTime) <= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 2;
                break;
            }
            else if (strtotime($reportTime) <= $start && strtotime($releaseTime) >= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 3;
                break;
            }
        }

        if ($index || $index === 0) {
            if ($hourType == 1){
                $this->workingPeriods[$index] = [ $value, $releaseTime ];
            }
            else if ($hourType == 2){
                $this->workingPeriods[$index] = [ $reportTime, $value ];
            }
            else {
                $this->workingPeriods[$index] = [ $reportTime, $releaseTime ];
            }
        }
        else {
            $this->workingPeriods[] = [$reportTime, $releaseTime];
        }

//        $this->setTotalHours();
    }

    public function setPTotalHours($duration)
    {
        /*
        $this->pTotalHours = 0;

        foreach ($this->pWorkingPeriods as $each) {
            $this->pTotalHours += Calculate_Duration($each[0], $each[1], null, 16);
        }
        */

        $this->pTotalHours += $duration;

        return $this->pTotalHours;
    }

    public function setTotalHours($duration)
    {
        /*
        $this->totalHours = 0;

        foreach ($this->workingPeriods as $each) {
            $this->totalHours += Calculate_Duration($each[0], $each[1], null, 16);
        }
        */

        $this->totalHours += $duration;

        return $this->totalHours;
    }


    public function setPlannedHoursAndSalary($selectedPeriod, $duration, $salaryRate, $reportTime, $releaseTime){
        if (!$selectedPeriod){
            return;
        }

        $this->setPWorkingPeriods($reportTime, $releaseTime);

        $this->setPTotalHours($duration);
        $this->pTotalSalary = $this->pTotalHours * $salaryRate;

        if (!isset($this->pTotalByPeriodHours[$selectedPeriod])){
            $this->pTotalByPeriodHours[$selectedPeriod] = 0;
            $this->pTotalSalaryByPeriod[$selectedPeriod] = 0;
        }

        $this->pTotalByPeriodHours[$selectedPeriod] = $this->pTotalHours;
        $this->pTotalSalaryByPeriod[$selectedPeriod] = $this->pTotalSalary;

    }

    public function setActualHoursAndSalary($selectedPeriod, $duration, $salaryRate, $reportTime, $releaseTime){
        if (!$selectedPeriod){
            return;
        }

        $this->setWorkingPeriods($reportTime, $releaseTime);

        $this->setTotalHours($duration);
        $this->totalSalary = $this->totalHours * $salaryRate;

        if (!isset($this->totalByPeriodHours[$selectedPeriod])){
            $this->totalByPeriodHours[$selectedPeriod] = 0;
            $this->totalSalaryByPeriod[$selectedPeriod] = 0;
        }

        $this->totalByPeriodHours[$selectedPeriod] = $this->totalHours;
        $this->totalSalaryByPeriod[$selectedPeriod] = $this->totalSalary;
    }


    public function setTotals(){

        $this->pTotalTime = $this->pTotalHours ? hoursToTime($this->pTotalHours, true, true) : null;
        $this->totalTime = $this->totalHours ? hoursToTime($this->totalHours, true, true) : null;

        if ($this->salaryRate){
            $this->pTotalSalary = round($this->pTotalHours * $this->salaryRate, 2);
            $this->totalSalary  = round($this->totalHours * $this->salaryRate, 2);
        }
        else{
            if ($this->pTotalSalary){
                $this->pTotalSalary = round($this->pTotalSalary, 2);
            }

            if ($this->totalSalary){
                $this->totalSalary = round($this->totalSalary, 2);
            }
        }
    }

    public function setPeriodTotals()
    {
        foreach ($this->pTotalByPeriodHours as $month => $each) {
            $this->pTotalByPeriodTime[$month] = hoursToTime($each, true, true);
            if ($this->salaryRate) {
                $this->pTotalSalaryByPeriod[$month] = round($each * $this->salaryRate, 2);
            } else if (isset($this->pTotalSalaryByPeriod[$month])) {
                $this->pTotalSalaryByPeriod[$month] = round($this->pTotalSalaryByPeriod[$month], 2);
            }
        }

        foreach ($this->totalByPeriodHours as $month => $each) {
            $this->totalByPeriodTime[$month] = hoursToTime($each, true, true);
            if ($this->salaryRate) {
                $this->totalSalaryByPeriod[$month] = round($each * $this->salaryRate, 2);
            } else if (isset($this->totalSalaryByPeriod[$month])) {
                $this->totalSalaryByPeriod[$month] = round($this->totalSalaryByPeriod[$month], 2);
            }
        }

        foreach ($this->pTotalByPeriodHours as $month => $each) {
            $planned = isset($this->pTotalByPeriodHours[$month]) ? $this->pTotalByPeriodHours[$month] : 0;
            $actual = isset($this->totalByPeriodHours[$month]) ? $this->totalByPeriodHours[$month] : 0;

            $this->plannedGAP[$month] = $planned - $this->contracted;
            $this->actualGAP[$month] = $actual - $planned;

            $this->shortHours[$month] = 0;
            $this->overtimeHours[$month] = 0;

            if ($this->actualGAP[$month] < 0){
                $this->shortHours[$month] += (-1) * $this->actualGAP[$month];
            }
            else {
                $this->overtimeHours[$month] += $this->actualGAP[$month];
            }
        }
    }
}
