<?php
namespace App\Classes\Staff\Report;

use App\Models\Airport;

class OverlapHoursCalculation
{
    /**
     * @var OverlapHours[]
     */
    public $overlapReportByUser = [];

    public $pInitHours = 0;
    public $initHours = 0;
    public $oInitHours = 0;

    public $pTotalHours = 0;

    public $totalHours = 0;
    public $holiday = 0;
    public $weekend = 0;
    public $night = 0;

    public $from;
    public $to;

    public function getNormalHours(){
        return $this->totalHours - $this->holiday - $this->weekend - $this->night;
    }

    public function getReportUserIDs(){
        $userIDs = [];
        foreach ($this->overlapReportByUser as $each){
            $userIDs[] = $each->user->id;
        }

        return array_values($userIDs);
    }

    public function __construct($staffHours, $staffHistory, $from, $to, $calculatePayrollHours = false)
    {
        $this->from = $from;
        $this->to = $to;

        $holidays = getHolidaysByStationIDs();
        $timezones = Airport::getHandlingStations("timezone", "id");
//        debug($timezones);

        foreach($staffHours["data"] as $i => $each){
//            debug(getUserLocationAirport($each->user, true));

            $item = new OverlapHours($each->user, $from, $to, $timezones);
            $item->loadWorkingPeriods($each->pWorkingPeriods, $each->workingPeriods);
            $this->overlapReportByUser[$i] = $item;
        }

        if ($staffHistory && isset($staffHistory["list"])) {
            foreach ($staffHistory["list"] as $i => $each) {
                if (isset($this->overlapReportByUser[$i])) {
                    $this->overlapReportByUser[$i]->loadOfficeDutiesPeriods($each["wHistory"]);
                }
                else {
                    $item = new OverlapHours($each["user"], $from, $to, $timezones);
                    $item->loadOfficeDutiesPeriods($each["wHistory"]);
                    $this->overlapReportByUser[$i] = $item;
                }
            }
        }

        try {
            foreach ($this->overlapReportByUser as &$item) {
                $item->init($holidays, $calculatePayrollHours);
//                debug($item->workingPeriods);
//                debug($item->printHours());

                $this->pTotalHours += $item->pTotalHours;
                $this->pInitHours += $item->pInitHours;
                $this->initHours += $item->initHours;

                // Office Duties
                $this->oInitHours += $item->oInitHours;

                // Total Hours (Office Duties + Actual Hours)
                $this->totalHours += $item->totalHours;

                $this->holiday += $item->holiday;
                $this->night += $item->night;
                $this->weekend += $item->weekend;
            }
        }
        catch (\Exception $e){
//            debug($e->getMessage());
        }
    }

    public function sortByUserLastName(){

        if (!$this->overlapReportByUser || !count($this->overlapReportByUser)){
            return;
        }

        usort($this->overlapReportByUser, array($this, "compareByLastName"));
    }

    function compareByLastName($objA, $objB)
    {
        return strcmp($objA->user->last_name, $objB->user->last_name);
    }

    public function addNonRosteredUsers($users){
        foreach ($users as $user){
            $this->overlapReportByUser[$user->id] = new OverlapHours($user, $this->from, $this->to);
        }
    }
}