<?php
namespace App\Classes\Staff\Report;

class OverlapHours
{
    public $airportID;

    public $night = 0;
    public $weekend = 0;
    public $holiday = 0;

    public $pTotalHours = 0;
    public $totalHours = 0;

    public $pInitHours = 0;
    public $initHours = 0;
    public $oInitHours = 0;

    public $pWorkingPeriods = [];
    public $workingPeriods = [];

    public $pPeriods = [];
    public $periods = [];
    public $officePeriods = [];

    public $timezone;
    public $user;

    public $nightShiftStart;
    public $nightShiftEnd;

    public $fromDateTime;
    public $toDateTime;

    public function getNormalHours(){
        return $this->totalHours - $this->holiday - $this->weekend - $this->night;
    }

    public function printHours(){
        // debug("NIGHT: {$this->night} | WEEKEND: {$this->weekend} | HOLIDAY: {$this->holiday} | pTOTAL: {$this->pTotalHours} | TOTAL: {$this->totalHours}");
    }

    public function __construct($user, $from, $to, $timezones = null)
    {
        $this->user = $user;
        $this->fromDateTime = date("Y-m-d", strtotime($from))." 00:00:00";
        $this->toDateTime = date("Y-m-d", strtotime($to)). " 23:59:59";

        $this->airportID = getUserLocationAirport($this->user, true);
//        debug("AP: ". $this->airportID);

        $this->nightShiftStart = strtotime("22:00:00");
        $this->nightShiftEnd = strtotime("06:00:00");

        if ($timezones){
            $this->timezone = $timezones[$this->airportID];
        }
    }

    public function loadWorkingPeriods($pWorkingPeriods, $workingPeriods){
        $this->pPeriods = $pWorkingPeriods;
        $this->periods = $workingPeriods;

        $this->setTotalHours($this->pInitHours, $this->pPeriods);
        $this->setTotalHours($this->initHours, $this->periods);
    }

    public function loadOfficeDutiesPeriods($periods){
        $this->officePeriods = $periods;

        $this->setTotalHours($this->oInitHours, $this->officePeriods);
    }

    public function init($holidays = [], $calculatePayrollHours = false){

        $this->pWorkingPeriods = array_merge($this->pPeriods, $this->officePeriods);
        $this->workingPeriods = array_merge($this->periods, $this->officePeriods);

        $this->calc($this->pWorkingPeriods);
        $this->calc($this->workingPeriods);

        $this->setTotalHours($this->pTotalHours, $this->pWorkingPeriods);
        $this->setTotalHours($this->totalHours, $this->workingPeriods, $calculatePayrollHours, $holidays);
    }

    public function calc(&$arr){
        usort($arr, function($a, $b)
        {
            return strtotime($a[0]) - strtotime($b[0]);
        });

        $n = 0; $len = count($arr);
        for ($i = 1; $i < $len; ++$i)
        {
            if (strtotime($arr[$i][0]) > strtotime($arr[$n][1]) + 1)
                $n = $i;
            else
            {
                if (strtotime($arr[$n][1]) < strtotime($arr[$i][1]))
                    $arr[$n][1] = $arr[$i][1];
                unset($arr[$i]);
            }
        }

        $arr = array_values($arr);
    }

    /*
    function setPWorkingPeriods($reportTime, $releaseTime){
        $index = $hourType = $value = null;

        foreach ($this->pWorkingPeriods as $i => $each) {
            $start = strtotime($each[0]);
            $end = strtotime($each[1]);

            if (strtotime($reportTime) >= $start && strtotime($reportTime) <= $end){

                $index = $i;
                $hourType = 1;
                $value = $each[0];
                // Pick the larger release time
                $releaseTime = strtotime($releaseTime) >= $end ? $releaseTime : $each[1];
                break;
            }
            else if (strtotime($releaseTime) >= $start && strtotime($releaseTime) <= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 2;
                break;
            }
            else if (strtotime($reportTime) <= $start && strtotime($releaseTime) >= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 3;
                break;
            }
        }

        if ($index || $index === 0) {
            if ($hourType == 1){
                $this->pWorkingPeriods[$index] = [ $value, $releaseTime ];
            }
            else if ($hourType == 2){
                $this->pWorkingPeriods[$index] = [ $reportTime, $value ];
            }
            else {
                $this->pWorkingPeriods[$index] = [ $reportTime, $releaseTime ];
            }
        }
        else {
            $this->pWorkingPeriods[] = [$reportTime, $releaseTime];
        }
    }

    function setWorkingPeriods($reportTime, $releaseTime){
        $index = $hourType = $value = null;

        foreach ($this->workingPeriods as $i => $each) {
            $start = strtotime($each[0]);
            $end = strtotime($each[1]);

            if (strtotime($reportTime) >= $start && strtotime($reportTime) <= $end){

                $index = $i;
                $hourType = 1;
                $value = $each[0];
                // Pick the larger release time
                $releaseTime = strtotime($releaseTime) >= $end ? $releaseTime : $each[1];
                break;
            }
            else if (strtotime($releaseTime) >= $start && strtotime($releaseTime) <= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 2;
                break;
            }
            else if (strtotime($reportTime) <= $start && strtotime($releaseTime) >= $end){

                $index = $i;
                $value = $each[1];
                $hourType = 3;
                break;
            }
        }

        if ($index || $index === 0) {
            if ($hourType == 1){
                $this->workingPeriods[$index] = [ $value, $releaseTime ];
            }
            else if ($hourType == 2){
                $this->workingPeriods[$index] = [ $reportTime, $value ];
            }
            else {
                $this->workingPeriods[$index] = [ $reportTime, $releaseTime ];
            }
        }
        else {
            $this->workingPeriods[] = [$reportTime, $releaseTime];
        }
    }
    */

    public function setTotalHours(&$totalVar, $periods, $calcPremiumHours = false, $holidays = [])
    {
        $totalVar = 0;

        $stationHolidays = isset($holidays[$this->airportID]) ? $holidays[$this->airportID] : [];

        $fromDateTimeStr = strtotime($this->fromDateTime);
        $toDateTimeStr = strtotime($this->toDateTime);

        foreach ($periods as $each) {
            $start = convertUtcToLocal($each[0], $this->timezone);
            $end = convertUtcToLocal($each[1], $this->timezone);

            $from = strtotime($start) < $fromDateTimeStr ? $this->fromDateTime : $start;
            $to = strtotime($end) > $toDateTimeStr ? $this->toDateTime : $end;

            if (strtotime($from) >= strtotime($to)){
                continue;
            }

            debug($from." - ".$to);
            $totalVar += Calculate_Duration($from, $to, null, 16);

            if ($calcPremiumHours){
                $this->setPremiumHours($from, $to, $stationHolidays);
            }
        }

        return $totalVar;
    }

    function setPremiumHours($start, $end, $holidays = []){

        $endStr = strtotime($end);
        for ($i = strtotime($start); $i <= $endStr; $i += 24*60*60) {
            $this->calcPremiumHours($i, ($i + 24*60*60 >  $endStr ? $endStr : strtotime(date("Y-m-d 23:59:59", $i))), $holidays);
        }
    }

    function calcPremiumHours($startStr, $endStr, $holidays){

        $startDate = date("Y-m-d", $startStr);
        $endDate = date("Y-m-d", $endStr);

        $startTime = strtotime(date("H:i:s", $startStr));
        $endTime = strtotime(date("H:i:s", $endStr));

        // debug("/ ".date("H:i", $startStr)." : ".date("H:i", $endStr));

        $holidayHours = $weekendHours = $nightHours = 0;
        // LIKE 21:00 - 03:00
        if ($startTime > $endTime)
        {
            // Holiday
            if (in_array($startDate, $holidays)){
                $holidayHours = secsToHours(strtotime("23:59:59") - $startTime);
                // debug("-1- ".$holidayHours);
            }
            else {
                // Weekend
                if (isSunday($startDate)){
                    $weekendHours = secsToHours(strtotime("23:59:59") - $startTime);
                }
                else {
                    // Night shift
                    $nightHours = secsToHours(strtotime("23:59:59") - ($startTime >= $this->nightShiftStart ? $startTime : $this->nightShiftStart));
//                    // debug("-1- ".$nightHours);
                }
            }

            // Holiday
            if (in_array($endDate, $holidays)){
                $holidayHours += secsToHours($endTime - strtotime("00:00:00"));
                // debug("-2- ".secsToHours($endTime));
            }
            else {
                // Weekend
                if (isSunday($endDate)){
                    $weekendHours += secsToHours($endTime - strtotime("00:00:00"));
                }
                else {
                    // Night shift
                    $nightHours += secsToHours(($endTime >= $this->nightShiftEnd ? $this->nightShiftEnd : $endTime) - strtotime("00:00:00"));
//                    // debug("-2- ".secsToHours(($endTime >= $this->nightShiftEnd ? $this->nightShiftEnd : $endTime) - strtotime("00:00")));
                }
            }


        }
        // same day hours
        else {
            // Standard 17:00 - 21:00

            // Holiday
            if (in_array($startDate, $holidays)) {
                $holidayHours = secsToHours($endStr - $startStr);
                // debug("-3-: $nightHours");
            } else {
                // Weekend
                if (isSunday($startDate)) {
                    $weekendHours = secsToHours($endStr - $startStr);
                } else {
                    // Night shift
                    if ($endTime > $this->nightShiftStart){
                        if ($startTime > $this->nightShiftStart){
                            $nightHours = secsToHours($endStr - $startStr);
                        }
                        else {
                            $nightHours = secsToHours($endTime - $this->nightShiftStart);
                        }
                    }
                    else if ($startTime < $this->nightShiftEnd) {
                        if ($endTime > $this->nightShiftEnd){
                            $nightHours = secsToHours( $this->nightShiftEnd  - $startTime);
                        }
                        else {
                            $nightHours = secsToHours($endStr - $startStr);
                        }

                    }

//                    // debug("NIGHT: $nightHours");
                }
            }
        }

        $this->holiday += $holidayHours;
        $this->weekend += $weekendHours;
        $this->night   += $nightHours;
    }

}