<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 23.02.17

 */

namespace App\Classes\Staff\Report;

use App\Classes\Staff\Flight\StaffFlight;

class FlightStaffHours
{
//    public $serviceType;
    public $staffList = [];

    public $flight;
    public $flightId;

    public $period;
    public $periodOption;
    public $salaryRate;

    public $contracted;
    public $plannedGAP = [];
    public $actualGAP = [];

    public $shortHours = [];
    public $overtimeHours = [];
    public $actualShortOvertimeHours = [];

    public $reason = null;
    // Planned
    public $pTotalHours = 0;
    public $pTotalTime = null;
    public $pTotalSalary = null;

    public $pTotalByPeriodHours = [];
    public $pTotalByPeriodTime  = [];
    public $pTotalSalaryByPeriod = [];

    // Actual
    public $totalHours = 0;
    public $totalTime = null;
    public $totalSalary = null;

    public $totalByPeriodHours = [];
    public $totalByPeriodTime  = [];
    public $totalSalaryByPeriod = [];

    /**
     * @param $period
     * @param $periodOption
     * @param null $staffFlight
     * @param null $handlingStations
     */
    public function __construct($period, $periodOption, $staffFlight = null, $handlingStations = null){
        $this->period = $period;
        $this->periodOption = $periodOption;

        if ($staffFlight) {
            $this->flight = $staffFlight->flight;
            $this->flightId = $staffFlight->flight_id;
            $this->reason = $staffFlight->reason;
//            $this->serviceType = getFlightsDepArrType($this->flight, $handlingStations);
        }
    }

    public function setPlannedHours($selectedPeriod, $hours){
        if (!$selectedPeriod){
            return;
        }

        $this->pTotalHours += $hours;

        if (!isset($this->pTotalByPeriodHours[$selectedPeriod])){
            $this->pTotalByPeriodHours[$selectedPeriod] = 0;
        }

        $this->pTotalByPeriodHours[$selectedPeriod] += $hours;
    }

    public function setPlannedHoursAndSalary($selectedPeriod, $hours, $salaryRate){
        if (!$selectedPeriod){
            return;
        }

        $this->pTotalHours += $hours;
        $this->pTotalSalary += $hours * $salaryRate;

        if (!isset($this->pTotalByPeriodHours[$selectedPeriod])){
            $this->pTotalByPeriodHours[$selectedPeriod] = 0;
            $this->pTotalSalaryByPeriod[$selectedPeriod] = 0;
        }

        $this->pTotalByPeriodHours[$selectedPeriod] += $hours;
        $this->pTotalSalaryByPeriod[$selectedPeriod] += $hours * $salaryRate;

    }

    public function setActualHours($selectedPeriod, $hours){
        if (!$selectedPeriod){
            return;
        }

        $this->totalHours += $hours;

        if (!isset($this->totalByPeriodHours[$selectedPeriod])){
            $this->totalByPeriodHours[$selectedPeriod] = 0;
        }

        $this->totalByPeriodHours[$selectedPeriod] += $hours;
    }

    public function setActualHoursAndSalary($selectedPeriod, $hours, $salaryRate){
        if (!$selectedPeriod){
            return;
        }

        $this->totalHours += $hours;
        $this->totalSalary += $hours * $salaryRate;

        if (!isset($this->totalByPeriodHours[$selectedPeriod])){
            $this->totalByPeriodHours[$selectedPeriod] = 0;
            $this->totalSalaryByPeriod[$selectedPeriod] = 0;
        }

        $this->totalByPeriodHours[$selectedPeriod] += $hours;
        $this->totalSalaryByPeriod[$selectedPeriod] += $hours * $salaryRate;

    }


    public function setTotals(){
        $this->pTotalTime = $this->pTotalHours ? hoursToTime($this->pTotalHours, true, true) : null;
        $this->totalTime = $this->totalHours ? hoursToTime($this->totalHours, true, true) : null;

        if ($this->salaryRate){
            $this->pTotalSalary = round($this->pTotalHours * $this->salaryRate, 2);
            $this->totalSalary = round($this->totalHours * $this->salaryRate, 2);
        }
        else{
            if ($this->pTotalSalary){
                $this->pTotalSalary = round($this->pTotalSalary, 2);
            }

            if ($this->totalSalary){
                $this->totalSalary = round($this->totalSalary, 2);
            }
        }
    }

    public function setPeriodTotals()
    {
        foreach ($this->pTotalByPeriodHours as $month => $each) {
            $this->pTotalByPeriodTime[$month] = hoursToTime($each, true, true);
            if ($this->salaryRate) {
                $this->pTotalSalaryByPeriod[$month] = round($each * $this->salaryRate, 2);
            } else if (isset($this->pTotalSalaryByPeriod[$month])) {
                $this->pTotalSalaryByPeriod[$month] = round($this->pTotalSalaryByPeriod[$month], 2);
            }
        }

        foreach ($this->totalByPeriodHours as $month => $each) {
            $this->totalByPeriodTime[$month] = hoursToTime($each, true, true);
            if ($this->salaryRate) {
                $this->totalSalaryByPeriod[$month] = round($each * $this->salaryRate, 2);
            } else if (isset($this->totalSalaryByPeriod[$month])) {
                $this->totalSalaryByPeriod[$month] = round($this->totalSalaryByPeriod[$month], 2);
            }
        }

        foreach ($this->pTotalByPeriodHours as $month => $each) {
            $planned = isset($this->pTotalByPeriodHours[$month]) ? $this->pTotalByPeriodHours[$month] : 0;
            $actual = isset($this->totalByPeriodHours[$month]) ? $this->totalByPeriodHours[$month] : 0;

            $this->plannedGAP[$month] = $planned - $this->contracted;
            $this->actualGAP[$month] = $actual - $planned;

            $this->shortHours[$month] = 0;
            $this->overtimeHours[$month] = 0;

            if ($this->actualGAP[$month] < 0){
                $this->shortHours[$month] += (-1) * $this->actualGAP[$month];
            }
            else {
                $this->overtimeHours[$month] += $this->actualGAP[$month];
            }
        }
    }
}
