<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 23.02.17

 */

namespace App\Classes\Staff\Report;

use App\Classes\Staff\Flight\StaffFlight;

class FlightHours
{
    public $flight_id;
    public $staffFlight;

    // Planned
    public $pTotalHours = 0;
    public $pTotalTime = null;
    public $pTotalSalary = null;

    public $pTotalByMonthHours = [];
    public $pTotalByMonthTime  = [];
    public $pTotalSalaryByMonth = [];

    // Actual
    public $totalHours = 0;
    public $totalTime = null;
    public $totalSalary = null;

    public $totalByMonthHours = [];
    public $totalByMonthTime  = [];
    public $totalSalaryByMonth = [];

    /**
     * @var StaffFlight $staffFlight
     */
    public function __construct($staffFlight = null){
        if ($staffFlight) {
            $this->flight_id = $staffFlight->flight_id;
        }
        $this->staffFlight = $staffFlight;
    }

    public function setPlannedHours($monthYear, $hours, $salaryRate){
        if (!$monthYear){
            return;
        }

        $this->pTotalHours += $hours;
        $this->pTotalSalary += $hours * $salaryRate;

        if (!isset($this->pTotalByMonthHours[$monthYear])){
            $this->pTotalByMonthHours[$monthYear] = 0;
            $this->pTotalSalaryByMonth[$monthYear] = 0;
        }

        $this->pTotalByMonthHours[$monthYear] += $hours;
        $this->pTotalSalaryByMonth[$monthYear] += $hours * $salaryRate;

    }

    public function setActualHours($monthYear, $hours, $salaryRate){
        if (!$monthYear){
            return;
        }

        $this->totalHours += $hours;
        $this->totalSalary += $hours * $salaryRate;

        if (!isset($this->totalByMonthHours[$monthYear])){
            $this->totalByMonthHours[$monthYear] = 0;
            $this->totalSalaryByMonth[$monthYear] = 0;
        }

        $this->totalByMonthHours[$monthYear] += $hours;
        $this->totalSalaryByMonth[$monthYear] += $hours * $salaryRate;

    }

    public function setTotals(){
        $this->pTotalTime = $this->pTotalHours ? hoursToTime($this->pTotalHours, true, true) : null;
        $this->totalTime = $this->totalHours ? hoursToTime($this->totalHours, true, true) : null;

        $this->pTotalSalary = $this->pTotalSalary ? round($this->pTotalSalary, 2) : null;
        $this->totalSalary = $this->totalSalary ? round($this->totalSalary, 2) : null;
    }

    public function setMonthlyTotals(){

        foreach ($this->pTotalByMonthHours as $month => $each) {
            $this->pTotalByMonthTime[$month] = hoursToTime($each, true, true);
            $this->pTotalSalaryByMonth[$month] = round($this->pTotalSalaryByMonth[$month], 2);
        }

        foreach ($this->totalByMonthHours as $month => $each) {
            $this->totalByMonthTime[$month] = hoursToTime($each, true, true);
            $this->totalSalaryByMonth[$month] = round($this->totalSalaryByMonth[$month], 2);
        }
    }
}
