<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 22.02.17

 */

namespace App\Classes\Staff\Flight;

use App\Classes\Simple\UserSimple;
use App\Models\FlightStaff;

class StaffFlight
{
    public $id;

    // Simplified
    public $user;

    public $userId;
    public $userName;
    public $serviceType;
    public $service;

    // Planned
    public $pReportDate;
    public $pReportTime;
    public $pReleaseTime;
    public $pDurationTime;
    public $pDurationHours;

    // Actual
    public $reportDate = null;
    public $reportTime = null;
    public $releaseTime = null;
    public $durationTime = null;
    public $durationHours = null;
    public $reason = null;

    public $aircraft;
    public $aircraftName;
    public $route;
    public $airline;
    public $flightNumber;
    public $flightInfo;
    public $flight;
    public $flight_id;

    public $departure;
    public $arrival;
    public $departureDate;
    public $arrivalDate;

    /**
     * @param FlightStaff $flightStaff
     */
    public function __construct($flightStaff){
        $this->id = $flightStaff->id;
        /**
         * 'user',
            'user.position',
            'user.location',
            'user.location.airport',
            'service',
            'flight',
            'flight.aircraft',
            'flight.flightNumber',
            'flight.flightNumber.airline',
            'flight.flightNumber.departureAirport',
            'flight.flightNumber.arrivalAirport',
         */
        $this->user = $flightStaff->user;
//        $this->user = new UserSimple($flightStaff->user);

        $this->userId = $flightStaff->user_id;
        $this->userName = $flightStaff->user->first_name." ".$flightStaff->user->last_name;

        $this->serviceType = $flightStaff->service_type;
        $this->service = $flightStaff->service;
        $this->reason = $flightStaff->reason;

        // Planned
        $this->pReportTime = $flightStaff->planned_report_time;
        $this->pReleaseTime = strtotime($flightStaff->planned_report_time) > strtotime($flightStaff->planned_release_time) ? $flightStaff->planned_report_time : $flightStaff->planned_release_time;
        $this->pReportDate = date("Y-m-d", strtotime($flightStaff->planned_report_time));

        $this->pDurationHours = Calculate_Duration($this->pReportTime, $this->pReleaseTime, null, 16);
        $this->pDurationTime = hoursToTime($this->pDurationHours, true, true);

        // Actual
        $this->reportTime = $flightStaff->report_time;
        $this->releaseTime = strtotime($flightStaff->report_time) > strtotime($flightStaff->release_time) ? $flightStaff->report_time : $flightStaff->release_time;

        if ($flightStaff->report_time && $flightStaff->release_time) {
            $this->reportDate = date("Y-m-d", strtotime($this->reportTime));
            $this->durationHours = Calculate_Duration($this->reportTime, $this->releaseTime, null, 16);
            $this->durationTime = hoursToTime($this->durationHours, true, true);
        }

//        $this->aircraft = $flightStaff->flight->aircraft;
//        $this->aircraftName = $this->aircraft ? $this->aircraft->name : "-";

        $flightNumber = $flightStaff->flight->flightNumber;
        $route = $flightNumber->departureAirport ? $flightNumber->departureAirport->iata : "";
        $route .= "-".($flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->iata : "");
        $this->route = $route;

        $this->airline = $flightNumber->airline;
        $this->flightNumber = $flightNumber;

        $this->flightInfo = ($this->airline ? $this->airline->iata."-" : "").$flightNumber->flight_number;

        $this->flight = $flightStaff->flight;
        $this->flight_id = $flightStaff->flight_id;
        $this->departure = getFlightDepartureDate($flightStaff->flight);
        $this->arrival = getFlightArrivalDate($flightStaff->flight);

        $this->departureDate = date("Y-m-d", strtotime($this->departure));
        $this->arrivalDate = date("Y-m-d", strtotime($this->arrival));
    }

    public function getReportPeriod($period, $planned = false){
        $dateVar = $planned ? "pReportDate" : "reportDate";

//      ['' => 'None', 'Daily' => 'Daily', 'Weekly' => 'Weekly', 'Monthly' => 'Monthly'];
        $format = "Y";
        switch($period){
            case "Daily":
                $format = "d M, Y";
                break;

            case "Weekly":
                $format = "W, Y";
                break;

            case "Monthly":
                $format = "m, Y";
                break;
        }

        return $this->{$dateVar} ? date($format, strtotime($this->{$dateVar})) : null;
    }

    public function getReportYear($planned = false){
        $dateVar = $planned ? "pReportDate" : "reportDate";

        return $this->{$dateVar} ? date("Y", strtotime($this->{$dateVar})) : null;
    }
}
