<?php

namespace App\Classes\Simple;


class UserSimple
{
    public $id;
    public $last_name;
    public $first_name;
    public $max_hours;
    public $min_hours;
    public $salary_h;
    public $cost_center;
    public $company;
    public $staff_number;
    public $location_id;

    public $location;
    public $position = [];

    public function __construct($user)
    {
        $this->id = $user->id;
        $this->first_name = $user->first_name;
        $this->last_name = $user->last_name;
        $this->max_hours = $user->max_hours;
        $this->min_hours = $user->min_hours;
        $this->cost_center = $user->cost_center;
        $this->company = $user->company;
        $this->salary_h = $user->salary_h;
        $this->staff_number = $user->staff_number;

        if ($user->position && count($user->position) && isset($user->position[0])){
            $this->position = [];
            $this->position[0] = new \stdClass();
            $this->position[0]->name = $user->position[0]->name;
        }

        $this->location_id = $user->location_id;
        if ($user->location) {
            $this->location = new \stdClass();
            $this->location->id = $user->location_id;
            $this->location->airport = null;
            if ($user->location->airport) {
                $this->location->airport = new \stdClass();
                $this->location->airport->iata = $user->location->airport->iata;
            }
        }
    }

}