<?php

namespace App\Classes\Simple;


class FlightNumberSimple
{
    public $id;
    public $flight_number;
    public $airline_id;
    public $departure_airport_id;
    public $arrival_airport_id;

    public $airline;
    public $departureAirport;
    public $arrivalAirport;

    public function __construct($flightNumber)
    {
        $this->id = $flightNumber->id;
        $this->flight_number = $flightNumber->flight_number;
        $this->airline_id = $flightNumber->airline_id;
        $this->departure_airport_id = $flightNumber->departure_airport_id;
        $this->arrival_airport_id = $flightNumber->arrival_airport_id;

        $this->airline = new \stdClass();
        $this->airline->id = $flightNumber->airline->id;
        $this->airline->iata = $flightNumber->airline->iata;
        $this->airline->icao = $flightNumber->airline->icao;

        $this->departureAirport = new \stdClass();
        if ($flightNumber->departureAirport){
            $this->departureAirport->id = $flightNumber->departureAirport->id;
            $this->departureAirport->iata = $flightNumber->departureAirport->iata;
            $this->departureAirport->icao = $flightNumber->departureAirport->icao;
        }
        else {
            $this->departureAirport->id = $flightNumber->departure_airport_id;
            $this->departureAirport->iata = "";
            $this->departureAirport->icao = "";
        }

        $this->arrivalAirport = new \stdClass();
        if ($flightNumber->arrivalAirport){
            $this->arrivalAirport->id   = $flightNumber->arrivalAirport->id;
            $this->arrivalAirport->iata = $flightNumber->arrivalAirport->iata;
            $this->arrivalAirport->icao = $flightNumber->arrivalAirport->icao;
        }
        else {
            $this->arrivalAirport->id = $flightNumber->arrival_airport_id;
            $this->arrivalAirport->iata = "";
            $this->arrivalAirport->icao = "";
        }
    }
}