<?php namespace App\Classes;

/**
 * Created by PhpStorm.

 */

use App\Models\Aircraft;
use App\Models\FlightCrew;
use App\Models\Location;
use App\Models\User;
use Illuminate\Support\Facades\DB;

class RosterFCM extends RosterSettings implements ScheduleInterface {
    // Rank1 = Captain, Rank2 = First Officer
    protected $pseudo_capt_count = 0;
    protected $pseudo_dyu_rank2 = false;
    protected $pseudo_dyu_rank1 = false;
    protected $pseudo_lbd_rank2 = false;
    protected $pseudo_lbd_rank1 =false;

    public function __construct($settings) {
        $this->roster_type = FCM_CREW;

        $locations = Location::where("crew_base", true)->get();

        foreach ($locations as $each) {
            $this->location[] = $each->airport ? $each->airport->iata : "--un--";
        }

        foreach ($settings['initial'] as $option => $value){
            $this->$option = $value;
        }

        if (isset($settings['crew_license'])){
            $this->crew_license_settings = $settings['crew_license'];
        }
    }

    public function Schedule($designated){

        $group_flights = $this->Route_Flights();

        $this->Available_Crew();

        $this->Designated_Crew_Setup($designated);

        $this->AircraftMinCrewRequirement();

        $iteration = 0;

        if ($this->pseudo_dyu_rank1)
            $this->Pseudo_Crew_Create($this->pseudo_dyu_rank1, ['base'=> $this->location[0],'captain'=>true]);
        if ($this->pseudo_dyu_rank2)
            $this->Pseudo_Crew_Create($this->pseudo_dyu_rank2, ['base'=>$this->location[0]]);
        if ($this->pseudo_lbd_rank1)
            $this->Pseudo_Crew_Create($this->pseudo_lbd_rank1, ['base'=>$this->location[1],'captain'=>true]);
        if ($this->pseudo_lbd_rank2)
            $this->Pseudo_Crew_Create($this->pseudo_lbd_rank2, ['base'=>$this->location[1]]);

        $keys['all_keys'] = $this->Search_FCM_GetAllKeys('all_keys');

        $last12months = date('Y-m-d', strtotime("$this->from - 12 months"));
        $ytd = date('Y-01-01');
        $this->FTL_Limitation_Flight_Hours($keys['all_keys'], $ytd, $this->from, 'flight_history');

        foreach ($group_flights as $j => $flights){

            $log = new RosterLog($this->crew, $flights);

            // Flight Departure (STD) Date
            $flight_date[$j] = date('Y-m-d', strtotime($flights[0]['std']));

            // Aircraft Type
            $aircraft_type = $flights[0]['aircraft_type'];

            $iteration++;

            // Get Cabin Crew Required(Policy)
            $fcm_policy = $flights[0]['policy_fcm'];

            // Get Cabin Crew Required(Minimum)
            $fcm_min = $flights[0]['min_fcm'];

            //Set Flight Type to ONE_FLIGHT or MANY_FLIGHTS
            $this->Flight_Count($flights);

            // Creates New FDP(s) after FDP Limit Check
            $new_fdp = $this->New_FDP_Create($flights, $aircraft_type, $fcm_min);

            // Get New FDP Total Hours (fdp->current)
            $new_fdp_total_hours = $this->New_FDP_Total_Hours($new_fdp);

            $log->AddToLog($this->Search_FCM_GetAllKeys('eligible'), "Initial Stage");

            if ($j == 0 || ($j > 0 && $flight_date[$j] != $flight_date[$j - 1])) {
                // Unavailable Periods Check
                $this->Unavailable_Periods_Check($this->crew, $flight_date[$j],'Unavailable_Periods');

                $log->AddToLog($this->Search_FCM_GetAllKeys('eligible'), "Unavailable Periods");
            }

            // Designated Flights Period Check
            $this->Unavailable_Periods_Check($this->crew, $flight_date[$j],'Designated_Periods', $new_fdp);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], 'Designated_Periods');

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], null, self::HOUR_RESTRICTION, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], 'Hour Restrictions');

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->fdp_7days, self::FDP_LAST_7_DAYS, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], "FDP 7 Days");

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->fdp_28days, self::FDP_LAST_28_DAYS, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], "FDP 28 Days");

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->ftl_7days, self::LAST_7_DAYS, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $log->AddToLog($keys['eligible'], "FTL 7 Days");
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j],$this->ftl_28days, self::LAST_28_DAYS, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], "FTL 28 Days");

            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->ftl_12months, self::LAST_12_MONTHS, $new_fdp_total_hours);
            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $log->AddToLog($keys['eligible'], "FTL Year To Date");

            // Aircraft Type Check
//            $keys['eligible'] = $this->Search_FCM_GetAllKeys('aircraft_type',$aircraft_type , $keys['eligible']);
            $log->AddToLog($keys['eligible'], "Aircraft Types");

            // Apply AC TYPES Restrictions
            $keys['eligible'] = $this->CrewRestrictionsCheck("aircraft_type", $flights, $keys['eligible']);
            $log->AddToLog($keys['eligible'], "Aircraft Types Restrictions");

            // Apply ROUTE Restrictions
            $keys['eligible'] = $this->CrewRestrictionsCheck("route", $flights, $keys['eligible']);
            $log->AddToLog($keys['eligible'], "Route");

            // Get All FCM Keys That have NOT BEEN SCHEDULED YET
            $keys['not_scheduled_yet'] = $this->Search_FCM_GetAllKeys('not_scheduled_yet',null, $keys['eligible']);

            // Cabin Crew Requirement (Use Policy in certain Flights)
            if (isset($new_fdp[0]->additional_crew))
                $fcm_req = $fcm_min + $new_fdp[0]->additional_crew;
            else
                $fcm_req = ($this->Crew_Policy_For_Flights($flights[0], $this->crew_policy_flight_numbers) == true ? $fcm_policy : $fcm_min);

            // DYU-LBD or LBD-DYU Flight Check
            $this->Flight_Sector($flights);

            // Get Final Key List And DHC Eligible List
            list($keys['priority1'], $keys['priority2'], $keys['priority3'], $keys['standby_previously']) = $this->Final_Key_Array($keys['eligible'], $keys['not_scheduled_yet'], $new_fdp);

            // Merge All Priority Keys
            $keys['all_available'] = array_merge($keys['priority1'], $keys['priority2'], $keys['priority3']);
            $log->AddToLog($keys['all_available'], "Priorities");

            // Priorities Those Who Have Exceeded Different HUB Stay Limit
            $keys['all_available'] = $this->Different_Hub_Stay_Limit($keys['all_available'], $flight_date[$j]);
            $log->AddToLog($keys['all_available'], "Hub Stay Limit");

            // Designated Crew Priorities
            $keys['designated'] = $this->Designated_Crew($new_fdp);

            // Refresh All Available List
            $keys['all_available'] = array_merge($keys['designated'], $keys['all_available']);
            $log->AddToLog($keys['all_available'], "Designated Crew");

            // Check CMC
            $keys['all_available'] = $this->Cmc_Check($keys['all_available'],$new_fdp,$flight_date[$j]);
            $log->AddToLog($keys['all_available'], "CMC Check");

            // Get captain up First and Return
            $keys['final'] = $this->Priority_First('captain', $keys['all_available'], $fcm_min, $new_fdp);
            $log->AddToLog($keys['final'], "Final");

            // Check If Final Key is Empty Create pseudo Crew
            $keys['final'] = $this->Pseudo_Crew_Check_Create($new_fdp, ['keys_final'=> $keys['final'], 'fcm_req' => $fcm_req]);

            // Schedule Priority 1 and 2/3 CCM
            $this->Schedule_Crew($keys['priority1'], $keys['final'], $new_fdp);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');

            // Get all Unused Keys after Schedule
            $keys['dhc_eligible'] = array_diff($keys['all_available'], $keys['final']);

            // DHC Eligible List Check if Has Been Previously DHC
            $keys['dhc_passed_check'] = $this->DHC_Crew_Check($keys['dhc_eligible']);

            // DHC Crew Scheduling
            $keys['dhc_final'] = $this->DHC_Crew_Schedule($new_fdp, $keys['eligible'], $keys['dhc_passed_check']);

            // Hub Check
            $this->Hub_Check($keys['final'], $keys['dhc_final'], $flight_date[$j]);

            // Standby Eligible List, Priority 1 Group is Excluded From Being Standby
            $keys['standby_eligible'] = array_diff($keys['all_available'], array_merge($keys['final'], $keys['priority1'], $keys['dhc_final']));

            // DHC Eligible List Check if Has Been Previously DHC
            $keys['standby_passed_check'] = $this->Standby_Crew_Check($keys['standby_eligible']);

            // Standby Previously Update
            $keys['standby_previously'] = array_diff($keys['standby_previously'], array_merge($keys['final'], $keys['priority1'], $keys['dhc_final']));

            // Check If Standby Final Key is Empty Create Pseudo Crew
            $keys['standby_pseudo'] = (empty($keys['standby_previously']) && empty($keys['standby_passed_check'])) ? $this->Pseudo_Crew_Check_Create($new_fdp, ['standby' => true]) : [];

            //Standby Scheduling
            $keys['standby_final'] = $this->Standby_Schedule($keys['standby_previously'], $keys['standby_passed_check'], $keys['standby_pseudo'], $new_fdp);

            // Create Flights That Are Scheduled For Crew
            $this->Create_Flights_Scheduled($flights, $j, $keys['final'], $keys['dhc_final'], $keys['standby_final'], $fcm_policy, $fcm_min, $fcm_req);

            /*if ($iteration == 50)
                break;*/
            $this->roster_log[] = $log;
        }

        foreach ($this->roster_log as $i => $each) {
            if ($i == count($this->roster_log) - 1){
                $each->DebugLog();
            }
        }


        return $this->Return_Variables();
    }

    public function AircraftMinCrewRequirement(){
        $aircraft = Aircraft::all();
        foreach ($aircraft as $each) {
            $this->aircraft_min_crew[$each->id] = $each->min_fcm;
        }
    }


    public function Return_Variables(){
        $this->scheduled_keys = $this->Search_FCM_GetAllKeys('scheduled');

        $pseudo = [
            'pseudo_capt_count' => $this->pseudo_capt_count,
            'pseudo_dyu_rank2'  => $this->pseudo_dyu_rank2,
            'pseudo_dyu_rank1'  => $this->pseudo_dyu_rank1,
            'pseudo_lbd_rank2'  => $this->pseudo_lbd_rank2,
            'pseudo_lbd_rank1'  => $this->pseudo_lbd_rank1,
            'total_add'         => ($this->pseudo_lbd_rank1 + $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'total_req'         => $this->pseudo_crew_count - ($this->pseudo_lbd_rank1 + $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'total'             => $this->pseudo_crew_count,
            'total_dyu_add'     => $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2,
            'total_dyu_req'     => $this->Pseudo_Count_By_Base($this->location[0]) - ($this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2),
            'total_dyu'         => $this->Pseudo_Count_By_Base($this->location[0]),
            'total_lbd_add'     => $this->pseudo_lbd_rank1 + $this->pseudo_lbd_rank2,
            'total_lbd_req'     => $this->Pseudo_Count_By_Base($this->location[1]) - ($this->pseudo_lbd_rank1 + $this->pseudo_lbd_rank2),
            'total_lbd'         => $this->Pseudo_Count_By_Base($this->location[1]),
            'fo_total_add'      => ($this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'fo_total_req'      => $this->Pseudo_Count_By_Base(null, 'cc') - ($this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'fo_total'          => $this->Pseudo_Count_By_Base(null, 'cc'),
            'fo_dyu_add'        => ($this->pseudo_dyu_rank2),
            'fo_dyu_req'        => $this->Pseudo_Count_By_Base($this->location[0], 'cc') - ($this->pseudo_dyu_rank2),
            'fo_dyu'            => $this->Pseudo_Count_By_Base($this->location[0], 'cc'),
            'fo_lbd_add'        => ($this->pseudo_lbd_rank2),
            'fo_lbd_req'        => $this->Pseudo_Count_By_Base($this->location[1], 'cc') - ($this->pseudo_lbd_rank2),
            'fo_lbd'            => $this->Pseudo_Count_By_Base($this->location[1], 'cc'),
            'captain_total_add' => ($this->pseudo_dyu_rank1 + $this->pseudo_lbd_rank1),
            'captain_total_req' => $this->Pseudo_Count_By_Base(null, null, 'captain') - ($this->pseudo_dyu_rank1 + $this->pseudo_lbd_rank1),
            'captain_total'     => $this->Pseudo_Count_By_Base(null, null, 'captain'),
            'captain_dyu_add'   => ($this->pseudo_dyu_rank1),
            'captain_dyu_req'   => $this->Pseudo_Count_By_Base($this->location[0], null, 'captain') - ($this->pseudo_dyu_rank1),
            'captain_dyu'       => $this->Pseudo_Count_By_Base($this->location[0], null, 'captain'),
            'captain_lbd_add'   => ($this->pseudo_lbd_rank1),
            'captain_lbd_req'   => $this->Pseudo_Count_By_Base($this->location[1], null, 'captain') - ($this->pseudo_lbd_rank1),
            'captain_lbd' => $this->Pseudo_Count_By_Base($this->location[1], null, 'captain'),
        ];
        return [$this->crew, $this->flights_scheduled, $this->flights_crew, $this->scheduled_keys, $this->lbd_crew_requirement, $pseudo];
    }


    /**
     * Gets Available Crew after checks applied and set FCM variable array within given period
     */
    public function Available_Crew()
    {
        $from = $this->from;
        $to = $this->to;

        $crew = User::with(['userHistory', 'crewRestrictionRoutes', 'crewRestrictionPairings', 'crewRestrictionAircraftTypes'])
            ->select([
                'users.id as id',
                'hour_restriction',
                'position_id',
                'structure__positions.name as position',
                'is_captain',
                'first_name',
                'last_name',
                'staff_number',
                'email',
                'dob',
                'doj',
                'picture',
                'thumb',
                'airports.iata AS base',
                'aruba_validation_from',
                'aruba_validation_to',
                'cmc_from',
                'cmc_to',
                'sep_12',
                'sep_36', 'crm_from', 'crm_to', 'security', 'medical_from', 'medical_to', 'flying_license_from', 'flying_license_to',
                'line_check_from', 'line_check_to', 'license_attachment_from', 'license_attachment_to', 'dgr_from', 'dgr_to', 'lpc_ir_from',
                'lpc_ir_to', 'opc_from', 'opc_to', 'tri_sfi_from', 'tri_sfi_to'
            ])
            ->join('users__departments', 'users.id', '=', 'users__departments.user_id')
            ->join('structure__positions', 'structure__positions.id', '=', 'users__departments.position_id')
            ->join('locations', 'users.location_id', '=', 'locations.id')
            ->join('airports', 'locations.airport_id', '=', 'airports.id')
            ->join('crew__flight', 'users.id', '=', 'crew__flight.user_id')
            ->where(function($sql){
                $sql->whereNull("users.resigned_date")
                    ->orWhere("users.resigned_date", EMPTY_DATE)
                    ->orWhere("users.resigned_date", ">", date("Y-m-d"));
            })
            ->whereNull('users.deleted_at')
            ->where('users__departments.department_id', 12)
            ->whereIn('structure__positions.type', [FCM_CPT_TYPE_ID, FCM_FA_TYPE_ID]);

        $crew = $crew->orderBy('id')
                     ->get();

        $all_conditions = [];

        if ($this->crew_license_settings) {
            foreach ($this->crew_license_settings as $index => $value) {
                if ($value)
                    $all_conditions[] = $index;
            }
        }

        foreach ($crew as $i => $each) {
            $id = $each->id;

            if (!isset($this->crew[$id])) {
                $this->crew[$id] = new FlightCrewMember;
            }

            // AC Types
            $aircraft_types = [];
            if (count($each->crewAircraftTypes)){
                foreach($each->crewAircraftTypes as $ac){
                    $aircraft_types[] = $ac->aircraft_type_id;
                }
            }

            $this->crew[$id]->id = $id;
            $this->crew[$id]->last_name = $each->last_name;
            $this->crew[$id]->first_name = $each->first_name;
            $this->crew[$id]->hour_restriction = $each->hour_restriction;
            $this->crew[$id]->base = $each->base;

            // Set Current Location
            $currentLocation = $this->GetCurrentLocation($id, $from);
            if ($currentLocation){
                $this->crew[$id]->current_location = $currentLocation->iata;
            }

            // Check If Captain
            $pos = trim($each->position);

            if ($each->is_captain || $each->position->type == FCM_CPT_TYPE_ID) {
                $this->crew[$id]->captain = true;
            }
            else {
                $this->crew[$id]->captain = false;
            }


            $detailsObj = clone $each;
            $this->crew[$id]->details = $detailsObj->toArray();
            $this->crew[$id]->details['aircraft_types'] = $aircraft_types;


            // Get Documentations Condition
            $this->SetCrewDocumentationsConditions($id, $all_conditions, $from, $to);

            // If Conditions Is Within FROM and TO -> the$n Record It
            $this->SetCrewHistoryConditions($each, $from, $to);

            // Set Crew Restrictions: AC Types, Pairing, Route
            $this->SetCrewRestrictions($each);

        }
    }

    /**
     * Create Pseudo Crew
     * @param $pseudo_count
     * @param $settings
     */
    public function Pseudo_Crew_Create($pseudo_count, $settings){
        if($pseudo_count > 0){
            for ($i = 0; $i < $pseudo_count; $i++){
                $id = $this->pseudo_id;
                $this->crew[$id] = new FlightCrewMember;
                $this->crew[$id]->id = $id;
                $this->crew[$id]->pseudo_crew = true;
                $this->crew[$id]->last_name = 'Pseudo';
                $this->crew[$id]->first_name = 'Crew #'.$this->pseudo_crew_count;

                if (isset($settings['captain'])) {
                    $this->crew[$id]->captain = true;
                    $this->pseudo_capt_count++;
                }

                $this->crew[$id]->start_eligible = true;
                $this->crew[$id]->eligible = true;
                $this->crew[$id]->base = $settings['base'];
                $this->crew[$id]->current_location =  $settings['base'];
                $this->pseudo_crew_count++;
                $this->pseudo_id++;
            }
        }
    }


    /**
     * Check If Shortage of Crew And If So Create Pseudo Crew
     * @param $new_fdp
     * @param $settings
     * @return array
     */
    public function Pseudo_Crew_Check_Create($new_fdp, $settings){
        if (!isset($settings['keys_final']))
            $settings['keys_final'] = [];

        $base = $new_fdp[0]->location_departure;
        if (($this->pseudo_dyu_set && $base == $this->location[0]) || ($this->pseudo_lbd_set && $base == $this->location[1])) {

            if (isset($settings['standby'])){
                $this->pseudo_crew_count++;
                $id = $this->pseudo_id;
                $this->crew[$id] = new FlightCrewMember;
                $this->crew[$id]->id = $id;
                $this->crew[$id]->pseudo_crew = true;
                $this->crew[$id]->last_name = 'Pseudo';
                $this->crew[$id]->first_name = 'Crew #' . $this->pseudo_crew_count;

                $this->crew[$id]->eligible = true;
                $this->crew[$id]->base = $base;
                $this->crew[$id]->current_location = $base;
                $this->pseudo_id++;

                $settings['keys_final'][] = $id;
            }
            else {
                if (count($settings['keys_final']) < $settings['fcm_req']) {
                    $required_crew = $settings['fcm_req'] - count($settings['keys_final']);
                    for ($i = 0; $i < $required_crew; $i++) {
                        $this->pseudo_crew_count++;
                        $id = $this->pseudo_id;
                        $this->crew[$id] = new FlightCrewMember;
                        $this->crew[$id]->id = $id;
                        $this->crew[$id]->pseudo_crew = true;
                        $this->crew[$id]->last_name = 'Pseudo';
                        $this->crew[$id]->first_name = 'Crew #' . $this->pseudo_crew_count;
                        // Requires Captain
                        if (empty($keys_final) && $i == 0) {
                            $this->crew[$id]->captain = true;
                            $this->pseudo_capt_count++;
                        }

                        $this->crew[$id]->eligible = true;
                        $this->crew[$id]->base = $base;
                        $this->crew[$id]->current_location = $base;
                        $this->pseudo_id++;
                        $settings['keys_final'][] = $id;
                    }
                }
            }
        }

        return $settings['keys_final'];

    }

    /**
     * Pseudo Counter By Base, captain
     * @param null $base
     * @param null $cc
     * @param null $captain
     * @return int
     */
    public function Pseudo_Count_By_Base($base = null, $cc = null, $captain = null){
        $counter = 0;
        for ($i = 1000000; $i < $this->pseudo_id; $i++){
            if (isset($base)){ // If Base Is Set
                if ($this->crew[$i]->base == $base) {
                    if (isset($captain)) { // captains Only
                        if ($this->crew[$i]->captain)
                            $counter++;
                    } else if (isset($cc)) { // Cabin Crew Only
                        if (!$this->crew[$i]->captain)
                            $counter++;
                    } else // All captain + Cabin Crew
                        $counter++;
                }
            }
            else { // Total Base Is Ignored
                if (isset($captain)) { // captains Only
                    if ($this->crew[$i]->captain)
                        $counter++;
                } else if (isset($cc)) { // Cabin Crew Only
                    if (!$this->crew[$i]->captain)
                        $counter++;
                } else // All captain + Cabin Crew
                    $counter++;
            }
        }
        return $counter;
    }

}
