<?php namespace App\Classes;
/**
 * Created by PhpStorm.

 */

use App\Models\Aircraft;
use App\Models\Location;
use App\Models\User;

class RosterCCM extends RosterSettings implements ScheduleInterface
{

    protected $pseudo_purser_count = 0;
    protected $pseudo_dyu_rank2 = false;
    protected $pseudo_dyu_rank1 = false;
    protected $pseudo_lbd_rank2 = false;
    protected $pseudo_lbd_rank1 = false;

    public function __construct($settings)
    {
        $this->roster_type = CCM_CREW;

        $locations = Location::where("crew_base", true)->get();

        foreach ($locations as $each) {
            $this->location[] = $each->airport ? $each->airport->iata : "--un--";
        }

        foreach ($settings['initial'] as $option => $value) {
            $this->$option = $value;
        }

        if (isset($settings['crew_license'])) {
            $this->crew_license_settings = $settings['crew_license'];
        }
    }

    public function Schedule($designated)
    {
        $group_flights = $this->Route_Flights();

        $this->Available_Crew();

        $this->Designated_Crew_Setup($designated);

        $this->AircraftMinCrewRequirement();

        $iteration = 0;

        if ($this->pseudo_dyu_rank1)
            $this->Pseudo_Crew_Create($this->pseudo_dyu_rank1, ['base' => $this->location[0], 'purser' => true]);
        if ($this->pseudo_dyu_rank2)
            $this->Pseudo_Crew_Create($this->pseudo_dyu_rank2, ['base' => $this->location[0]]);
        if ($this->pseudo_lbd_rank1)
            $this->Pseudo_Crew_Create($this->pseudo_lbd_rank1, ['base' => $this->location[1], 'purser' => true]);
        if ($this->pseudo_lbd_rank2)
            $this->Pseudo_Crew_Create($this->pseudo_lbd_rank2, ['base' => $this->location[1]]);

        $keys['all_keys'] = $this->Search_FCM_GetAllKeys('all_keys');
        $last12months = date('Y-m-d', strtotime("$this->from - 12 months"));
        $ytd = date('Y-01-01');
        $this->FTL_Limitation_Flight_Hours($keys['all_keys'], $ytd, $this->from, 'flight_history');


//        return 1;

        foreach ($group_flights as $j => $flights) {
            $iteration++;

            // Flight Departure (STD) Date
            $flight_date[$j] = date('Y-m-d', strtotime($flights[0]['std']));

            // Aircraft Type
            $aircraft_type = $flights[0]['aircraft_type'];

            // Get Cabin Crew Required(Policy)
            $ccm_policy = $flights[0]['policy_ccm'];

            // Get Cabin Crew Required(Minimum)
            $ccm_min = $flights[0]['min_ccm'];

            //Set Flight Type to ONE_FLIGHT or MANY_FLIGHTS
            $this->Flight_Count($flights);

            // Creates New FDP(s) after FDP Limit Check
            $new_fdp = $this->New_FDP_Create($flights, $aircraft_type, $ccm_min);

            // Get New FDP Total Hours (fdp->current)
            $new_fdp_total_hours = $this->New_FDP_Total_Hours($new_fdp);

            if ($j == 0 || ($j > 0 && $flight_date[$j] != $flight_date[$j - 1])) {
                // Unavailable Periods Check
                $this->Unavailable_Periods_Check($this->crew, $flight_date[$j], 'Unavailable_Periods');
            }

            // Designated Flights Period Check
            $this->Unavailable_Periods_Check($this->crew, $flight_date[$j], 'Designated_Periods', $new_fdp);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], null, self::HOUR_RESTRICTION, $new_fdp_total_hours);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->fdp_7days, self::FDP_LAST_7_DAYS, $new_fdp_total_hours);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->fdp_28days, self::FDP_LAST_28_DAYS, $new_fdp_total_hours);


            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->ftl_7days, self::LAST_7_DAYS, $new_fdp_total_hours);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->ftl_28days, self::LAST_28_DAYS, $new_fdp_total_hours);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');
            $this->FTL_Limitation_Check($keys['eligible'], $flight_date[$j], $this->ftl_12months, self::LAST_12_MONTHS, $new_fdp_total_hours);


            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');

            // Aircraft Type Check
//            $keys['eligible'] = $this->Search_FCM_GetAllKeys('aircraft_type', $aircraft_type, $keys['eligible']);

            // Apply AC TYPES Restrictions
            $keys['eligible'] = $this->CrewRestrictionsCheck("aircraft_type", $flights, $keys['eligible']);

            // Apply ROUTE Restrictions
            $keys['eligible'] = $this->CrewRestrictionsCheck("route", $flights, $keys['eligible']);

            // Get All FCM Keys That have NOT BEEN SCHEDULED YET
            $keys['not_scheduled_yet'] = $this->Search_FCM_GetAllKeys('not_scheduled_yet', null, $keys['eligible']);

            // Cabin Crew Requirement (Use Policy in certain Flights)
            if (isset($new_fdp[0]->additional_crew))
                $ccm_req = $ccm_min + $new_fdp[0]->additional_crew;
            else
                $ccm_req = $this->Crew_Policy_For_Flights($flights[0], $this->crew_policy_flight_numbers) ? $ccm_policy : $ccm_min;

            // DYU-LBD or LBD-DYU Flight Check
            $this->Flight_Sector($flights);


            // Get Final Key List And DHC Eligible List
            list($keys['priority1'], $keys['priority2'], $keys['priority3'], $keys['standby_previously']) = $this->Final_Key_Array($keys['eligible'], $keys['not_scheduled_yet'], $new_fdp);


            // Merge All Priority Keys
            $keys['all_available'] = array_merge($keys['priority1'], $keys['priority2'], $keys['priority3']);


            // Priorities Those Who Have Exceeded Different HUB Stay Limit
            $keys['all_available'] = $this->Different_Hub_Stay_Limit($keys['all_available'], $flight_date[$j]);

            // Designated Crew Priorities
            $keys['designated'] = $this->Designated_Crew($new_fdp);

            // Refresh All Available List
            $keys['all_available'] = array_merge($keys['designated'], $keys['all_available']);

            // Check CMC
            $keys['all_available'] = $this->Cmc_Check($keys['all_available'], $new_fdp, $flight_date[$j]);

            // Get Purser up First and Return
            $keys['all_available'] = $this->Priority_First('purser', $keys['all_available'], $ccm_min, $new_fdp);

            // Put Male -> Last Position
            $keys['final'] = $this->Priority_First('male_last', $keys['all_available'], $ccm_min, $new_fdp);

            // Check If Final Key is Empty Create pseudo Crew
            $keys['final'] = $this->Pseudo_Crew_Check_Create($new_fdp, ['keys_final' => $keys['final'], 'cabin_crew_requirement' => $ccm_req]);

            // Schedule Priority 1 and 2/3 CCM
            $this->Schedule_Crew($keys['priority1'], $keys['final'], $new_fdp);

            // Find Eligible FCM Ids
            $keys['eligible'] = $this->Search_FCM_GetAllKeys('eligible');

            // Get all Unused Keys after Schedule
            $keys['dhc_eligible'] = array_diff($keys['all_available'], $keys['final']);

            // DHC Eligible List Check if Has Been Previously DHC
            $keys['dhc_passed_check'] = $this->DHC_Crew_Check($keys['dhc_eligible']);

            // DHC Crew Scheduling
            $keys['dhc_final'] = $this->DHC_Crew_Schedule($new_fdp, $keys['eligible'], $keys['dhc_passed_check']);

            // Hub Check
            $this->Hub_Check($keys['final'], $keys['dhc_final'], $flight_date[$j]);

            // Standby Eligible List, Priority 1 Group is Excluded From Being Standby
            $keys['standby_eligible'] = array_diff($keys['all_available'], array_merge($keys['final'], $keys['priority1'], $keys['dhc_final']));

            // DHC Eligible List Check if Has Been Previously DHC
            $keys['standby_passed_check'] = $this->Standby_Crew_Check($keys['standby_eligible']);

            // Standby Previously Update
            $keys['standby_previously'] = array_diff($keys['standby_previously'], array_merge($keys['final'], $keys['priority1'], $keys['dhc_final']));

            // Check If Standby Final Key is Empty Create Pseudo Crew
            $keys['standby_pseudo'] = (empty($keys['standby_previously']) && empty($keys['standby_passed_check'])) ? $this->Pseudo_Crew_Check_Create($new_fdp, ['standby' => true]) : [];

            //Standby Scheduling
            $keys['standby_final'] = $this->Standby_Schedule($keys['standby_previously'], $keys['standby_passed_check'], $keys['standby_pseudo'], $new_fdp);

            // Create Flights That Are Scheduled For Crew
            $this->Create_Flights_Scheduled($flights, $j, $keys['final'], $keys['dhc_final'], $keys['standby_final'], $ccm_policy, $ccm_min, $ccm_req);
        }

        return $this->Return_Variables();
    }


    public function AircraftMinCrewRequirement(){
        $aircraft = Aircraft::all();
        foreach ($aircraft as $each) {
            $this->aircraft_min_crew[$each->id] = $each->min_ccm;
        }
    }


    public function Return_Variables()
    {
        $this->scheduled_keys = $this->Search_FCM_GetAllKeys('scheduled');

        $pseudo = [
            'pseudo_dyu_set' => $this->pseudo_dyu_set,
            'pseudo_lbd_set' => $this->pseudo_lbd_set,
            'pseudo_purser_count' => $this->pseudo_purser_count,
            'pseudo_dyu_rank2' => $this->pseudo_dyu_rank2,
            'pseudo_dyu_rank1' => $this->pseudo_dyu_rank1,
            'pseudo_lbd_rank2' => $this->pseudo_lbd_rank2,
            'pseudo_lbd_rank1' => $this->pseudo_lbd_rank1,
            'total_add' => ($this->pseudo_lbd_rank1 + $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'total_req' => $this->pseudo_crew_count - ($this->pseudo_lbd_rank1 + $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'total' => $this->pseudo_crew_count,
            'total_dyu_add' => $this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2,
            'total_dyu_req' => $this->Pseudo_Count_By_Base($this->location[0]) - ($this->pseudo_dyu_rank1 + $this->pseudo_dyu_rank2),
            'total_dyu' => $this->Pseudo_Count_By_Base($this->location[0]),
            'total_lbd_add' => $this->pseudo_lbd_rank1 + $this->pseudo_lbd_rank2,
            'total_lbd_req' => $this->Pseudo_Count_By_Base($this->location[1]) - ($this->pseudo_lbd_rank1 + $this->pseudo_lbd_rank2),
            'total_lbd' => $this->Pseudo_Count_By_Base($this->location[1]),
            'cc_total_add' => ($this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'cc_total_req' => $this->Pseudo_Count_By_Base(null, 'cc') - ($this->pseudo_dyu_rank2 + $this->pseudo_lbd_rank2),
            'cc_total' => $this->Pseudo_Count_By_Base(null, 'cc'),
            'cc_dyu_add' => ($this->pseudo_dyu_rank2),
            'cc_dyu_req' => $this->Pseudo_Count_By_Base($this->location[0], 'cc') - ($this->pseudo_dyu_rank2),
            'cc_dyu' => $this->Pseudo_Count_By_Base($this->location[0], 'cc'),
            'cc_lbd_add' => ($this->pseudo_lbd_rank2),
            'cc_lbd_req' => $this->Pseudo_Count_By_Base($this->location[1], 'cc') - ($this->pseudo_lbd_rank2),
            'cc_lbd' => $this->Pseudo_Count_By_Base($this->location[1], 'cc'),
            'purser_total_add' => ($this->pseudo_dyu_rank1 + $this->pseudo_lbd_rank1),
            'purser_total_req' => $this->Pseudo_Count_By_Base(null, null, 'purser') - ($this->pseudo_dyu_rank1 + $this->pseudo_lbd_rank1),
            'purser_total' => $this->Pseudo_Count_By_Base(null, null, 'purser'),
            'purser_dyu_add' => ($this->pseudo_dyu_rank1),
            'purser_dyu_req' => $this->Pseudo_Count_By_Base($this->location[0], null, 'purser') - ($this->pseudo_dyu_rank1),
            'purser_dyu' => $this->Pseudo_Count_By_Base($this->location[0], null, 'purser'),
            'purser_lbd_add' => ($this->pseudo_lbd_rank1),
            'purser_lbd_req' => $this->Pseudo_Count_By_Base($this->location[1], null, 'purser') - ($this->pseudo_lbd_rank1),
            'purser_lbd' => $this->Pseudo_Count_By_Base($this->location[1], null, 'purser'),
        ];

        return [$this->crew, $this->flights_scheduled, $this->flights_crew, $this->scheduled_keys, $this->lbd_crew_requirement, $pseudo];
    }


    /**
     * Gets Available Crew after checks applied and set FCM variable array within given period
     */
    public function Available_Crew()
    {
        $from = $this->from;
        $to = $this->to;

        $crew = User::with(['userHistory', 'crewAircraftTypes', 'crewRestrictionRoutes', 'crewRestrictionPairings', 'crewRestrictionAircraftTypes'])
              ->select([
                'users.id as id',
                'hour_restriction',
                'position_id',
                'structure__positions.name as position',
                'structure__positions.type as position_type',
                'first_name',
                'last_name',
                'staff_number',
                'email',
                'gender',
                'dob',
                'doj',
                'picture',
                'thumb',
                'location_id',
                'is_contractor',
                'is_purser',
                'license_validity',
                'medical_next',
                'cmc_from',
                'cmc_to',
                'sep_from',
                'sep_to',
                'crm_from',
                'crm_to',
                'security_from',
                'security_to',
                'line_check_from',
                'line_check_to',
                'dgr_from',
                'dgr_to',
                'practical_from',
                'practical_to',
                'airports.iata AS base'
            ])
            ->join('users__departments', 'users.id', '=', 'users__departments.user_id')
            ->join('structure__positions', 'structure__positions.id', '=', 'users__departments.position_id')
            ->join('crew__cabin', 'users.id', '=', 'crew__cabin.user_id')
            ->join('locations', 'users.location_id', '=', 'locations.id')
            ->join('airports', 'locations.airport_id', '=', 'airports.id')
            ->where(function($sql){
                $sql->whereNull("users.resigned_date")
                    ->orWhere("users.resigned_date", EMPTY_DATE)
                    ->orWhere("users.resigned_date", ">", date("Y-m-d"));
            })
            ->whereNull('users.deleted_at')
            ->where('users__departments.department_id', 14)

            ->whereIn('structure__positions.type', [CCM_PSR_TYPE_ID, CCM_CC_TYPE_ID]);
            /*
            ->whereIn('structure__positions.name', [
                PURSER_POSITION,
                FLIGHT_ATTENDANT_POSITION,
                INSTRUCTOR_FLIGHT_ATTENDANT_POSITION,
                SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION
            ]);
            */

        $crew = $crew->orderBy('id')
                      ->get();

        $all_conditions = [];

        foreach ($this->crew_license_settings as $index => $value) {
            if ($value)
                $all_conditions[] = $index;
        }

        foreach ($crew as $i => $each) {
            $id = $each->id;

            if (!isset($this->crew[$id])) {
                $this->crew[$id] = new CabinCrewMember;
            }

            // AC Types
            $aircraft_types = [];
            if (count($each->crewAircraftTypes)){
                foreach($each->crewAircraftTypes as $ac){
                    $aircraft_types[] = $ac->aircraft_type_id;
                }
            }

            $this->crew[$id]->id = $id;
            $this->crew[$id]->last_name = $each->last_name;
            $this->crew[$id]->first_name = $each->first_name;
            $this->crew[$id]->hour_restriction = $each->hour_restriction;
            $this->crew[$id]->gender = $each->gender;
            $this->crew[$id]->base = $each->base;

            // Set Current Location
            $currentLocation = $this->GetCurrentLocation($id, $from);

            if ($currentLocation){
                $this->crew[$id]->current_location = $currentLocation->iata;
            }

            // Check if Purser
            if ($each->is_purser || $each->position_type == CCM_PSR_TYPE_ID) {
                $this->crew[$id]->purser = true;
            }
            else {
                $this->crew[$id]->purser = false;
            }

            // Crew Details
            $detailsObj = clone $each;
            $this->crew[$id]->details = $detailsObj->toArray();
            $this->crew[$id]->details['aircraft_types'] = $aircraft_types;

            // Get Documentations Condition
            $this->SetCrewDocumentationsConditions($id, $all_conditions, $from, $to);

            // If Conditions Is Within FROM and TO -> the$n Record It
            $this->SetCrewHistoryConditions($each, $from, $to);

            // Set Crew Restrictions: AC Types, Pairing, Route
            $this->SetCrewRestrictions($each);
        }
    }

    /**
     * Create Pseudo Crew
     * @param $pseudo_count
     * @param $settings
     */
    public function Pseudo_Crew_Create($pseudo_count, $settings)
    {
        if ($pseudo_count > 0) {
            for ($i = 0; $i < $pseudo_count; $i++) {
                $id = $this->pseudo_id;
                $this->crew[$id] = new CabinCrewMember;
                $this->crew[$id]->id = $id;
                $this->crew[$id]->pseudo_crew = true;
                $this->crew[$id]->last_name = 'Pseudo';
                $this->crew[$id]->first_name = 'Crew #' . $this->pseudo_crew_count;

                if (isset($settings['purser'])) {
                    $this->crew[$id]->purser = true;
                    $this->pseudo_purser_count++;
                }

                $this->crew[$id]->start_eligible = true;
                $this->crew[$id]->eligible = true;
                $this->crew[$id]->base = $settings['base'];
                $this->crew[$id]->current_location = $settings['base'];
                $this->pseudo_crew_count++;
                $this->pseudo_id++;
            }
        }
    }


    /**
     * Check If Shortage of Crew And If So Create Pseudo Crew
     * @param $new_fdp
     * @param $settings
     * @return array
     */
    public function Pseudo_Crew_Check_Create($new_fdp, $settings)
    {
        if (!isset($settings['keys_final']))
            $settings['keys_final'] = [];

        $base = $new_fdp[0]->location_departure;
        if (($this->pseudo_dyu_set && $base == $this->location[0]) || ($this->pseudo_lbd_set && $base == $this->location[1])) {

            if (isset($settings['standby'])) {
                $this->pseudo_crew_count++;
                $id = $this->pseudo_id;
                $this->crew[$id] = new CabinCrewMember;
                $this->crew[$id]->id = $id;
                $this->crew[$id]->pseudo_crew = true;
                $this->crew[$id]->last_name = 'Pseudo';
                $this->crew[$id]->first_name = 'Crew #' . $this->pseudo_crew_count;

                $this->crew[$id]->eligible = true;
                $this->crew[$id]->base = $base;
                $this->crew[$id]->current_location = $base;
                $this->pseudo_id++;

                $settings['keys_final'][] = $id;
            } else {
                if (count($settings['keys_final']) < $settings['cabin_crew_requirement']) {
                    $required_crew = $settings['cabin_crew_requirement'] - count($settings['keys_final']);
                    for ($i = 0; $i < $required_crew; $i++) {
                        $this->pseudo_crew_count++;
                        $id = $this->pseudo_id;
                        $this->crew[$id] = new CabinCrewMember;
                        $this->crew[$id]->id = $id;
                        $this->crew[$id]->pseudo_crew = true;
                        $this->crew[$id]->last_name = 'Pseudo';
                        $this->crew[$id]->first_name = 'Crew #' . $this->pseudo_crew_count;
                        // Requires Purser
                        if (empty($keys_final) && $i == 0) {
                            $this->crew[$id]->purser = true;
                            $this->pseudo_purser_count++;
                        }

                        $this->crew[$id]->eligible = true;
                        $this->crew[$id]->base = $base;
                        $this->crew[$id]->current_location = $base;
                        $this->pseudo_id++;
                        $settings['keys_final'][] = $id;
                    }
                }
            }
        }

        return $settings['keys_final'];

    }

    /**
     * Pseudo Counter By Base, Purser
     * @param null $base
     * @param null $cc
     * @param null $purser
     * @return int
     */
    public function Pseudo_Count_By_Base($base = null, $cc = null, $purser = null)
    {
        $counter = 0;
        for ($i = 1000000; $i < $this->pseudo_id; $i++) {
            if (isset($base)) { // If Base Is Set
                if ($this->crew[$i]->base == $base) {
                    if (isset($purser)) { // Pursers Only
                        if ($this->crew[$i]->purser)
                            $counter++;
                    } else if (isset($cc)) { // Cabin Crew Only
                        if (!$this->crew[$i]->purser)
                            $counter++;
                    } else // All Purser + Cabin Crew
                        $counter++;
                }
            } else { // Total Base Is Ignored
                if (isset($purser)) { // Pursers Only
                    if ($this->crew[$i]->purser)
                        $counter++;
                } else if (isset($cc)) { // Cabin Crew Only
                    if (!$this->crew[$i]->purser)
                        $counter++;
                } else // All Purser + Cabin Crew
                    $counter++;
            }
        }
        return $counter;
    }

}
