<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 07.05.17

 */

namespace App\Classes\RadarBox;


use App\Models\Aircraft;
use App\Models\AircraftType;
use App\Models\Airline;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightTracker;
use App\Models\FlightTrackerDetail;

class RadarBoxParse
{
    public static function createOrUpdateFlightTracker(Flight $flight, $data, Airline $airline = null, Aircraft $aircraft = null, AircraftType $aircraftType = null){

        $flightTracker = FlightTracker::where("flight_id", $flight->id)
            ->first();

        return FlightTracker::createOrUpdate($data, $flight, $flightTracker, $airline, $aircraft, $aircraftType);

    }

    public static function searchFlight($flightNumbers, $std, $atd = null){
        $flight = null;

        $dateSTD = date("Y-m-d", strtotime($std));

        $whereRaw = "((s_flights.ptd IS NOT NULL AND s_flights.ptd != '' AND DATE(s_flights.ptd) = '$dateSTD')
                      OR (s_flights.std IS NOT NULL AND s_flights.std != '' AND DATE(s_flights.std) = '$dateSTD')";
        if ($atd){
            $dateATD = date("Y-m-d", strtotime($atd));
            $whereRaw .= "OR (s_flights.atd IS NOT NULL AND s_flights.atd != '' AND DATE(s_flights.atd) = '$dateATD')
                          OR (s_flights.etd IS NOT NULL AND s_flights.etd != '' AND DATE(s_flights.etd) = '$dateATD')";
        }

        $whereRaw .= ")";

        foreach ($flightNumbers as $fnEach) {
            $findFlight = Flight::where("flight_number_id", "=", $fnEach->id)
                ->whereNull("cancelled_at")
                ->whereNull("deleted_at")
                ->whereRaw($whereRaw)
                ->first();

            // If Flight Found -> Break
            if ($findFlight){
                $flight = $findFlight;
                break;
            }
        }

        return $flight;
    }

    public static function searchFlightNumber($fniata, Airline $airline = null){

        // parse FN
        $match = self::parseFlightNumber($fniata);

        if (!$airline){
            $airline = Airline::where("iata", $match["airline"])->first();
        }

        // FN
        return FlightNumber::where("airline_id", $airline->id)
            ->where("flight_number", $match["flightNumber"])
            ->whereNull("deleted_at")
            ->get();

    }

    public static function parseDateTime($dateTimeString){
        preg_match('/^(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})$/', $dateTimeString, $m);

        if ($m && count($m) == 6){
            $date = date("Y-m-d H:i", strtotime("$m[1]-$m[2]-$m[3] $m[4]:$m[5]"));
        }
        else {
            $date = date("Y-m-d H:i:s", strtotime($dateTimeString));
        }

        return $date;
    }

    public static function parseFlightNumber($fniata){
        preg_match('/^(\w{2})(\d{1,5}[A-Z]{0,2})$/', $fniata, $m);
        return [
            "airline"       => $m[1],
            "flightNumber"  => $m[2],
        ];
    }

}
