<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;

use App\Classes\Parsing\Helpers\ParseHelper;
use App\Classes\Parsing\Helpers\ParseValidation;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\Country;
use App\Models\Message2018;

class UpdateMessageTypes
{
    public $types = [
        CPM,
        UCM,
        LOADSHEET,
        LOADSHEET_FINAL,
        LDM,
        PSM,
        PTM,
        LPM,
        TPM,
        FAG,
        ONLOAD,
        NOT,
        NOTOC,
        COMRO,
        COM,
        WAB,
        TXT_ING,
        PNL,
        PRL,
        ADL,
        SLS,
        HBG,
        LIR,
        CAL,
        PAL,

        CREW_LIST,
    ];

    public $sentDate;
    public $messageLog = [];

    public $messages;
    public $messageType;
    public $type;

    public $handlingAirline;

    public $skipDateRangeCheck = null;

    public $airlineModule;
    public $localTimeMessages = [
        PRL,
        PNL,
        ADL,
        PTM,
        PSM,
        SLS,
        TPM,
        PSM,
    ];

    public $exceptionStationsList = [
        "LDB",
    ];

    public function __construct(){

    }

    public function init(){
        ini_set("max_execution_time", 600);
        ini_set('memory_limit', '1024M');

        $this->airlineModule = airlineModule();

        $this->messages =  Message2018::
            whereNull("updated_at")
            ->whereNull("created_by")
//            ->whereNull("message")
//            ->whereNull("type")
            ->limit(100000)
//            where("id", 1205874)
            ->get([
                "id",
                "message",
                "type",
                "email_body",
                "actual_id",
                "updated_at",
                "updated_by",
                "created_by",
            ]);

        foreach ($this->messages as &$message) {
            $this->type = $this->messageType = null;

            $this->run($message->email_body);

            try {
                $message->message = $this->messageType;
                $message->type = $this->type;
                $message->updated_at = date("Y-m-d H:i:s");
                $message->updated_by = 1;
                $message->save();
            }
            catch (\Exception $e){
                $message->message = null;
                $message->type = null;
                $message->actual_id = null;
                $message->created_by = 1;
                $message->save();
            }
        }
    }

    public function run($emailBody){

        if (preg_match('/^(?:\s*.\s*)?(DIV)/m', $emailBody)) {
            $this->messageType = MVT;

            $this->type = MVT_DIVERSION;

        }
        else if (preg_match('/^(?:\s*.\s*)?(MVT)/m', $emailBody)) {

            $this->messageType = MVT;

            if (preg_match('/\b(?:AD|ED)[0-9]+/m', $emailBody)) {

                $this->type = MVT_DEPARTURE;

                debug("MVT - ARR CREATED");
            }
            // Arrival message
            else if (preg_match('/\bAA[0-9]+/m', $emailBody)) {

                debug("MVT - ARR matched OK");

                $this->type = MVT_ARRIVAL;

                debug("MVT - ARR CREATED");
            }
        }

        // LDM|UCM|PSM|PTM|CPM|LPM|TPM|COMRO|COM|WAB|TXT_ING|PNL|ADL
        else {
            foreach ($this->types as $type)
            {
                // Special case for TXT_ING
                /// ^(?:\s*.\s*)?(TPM)
                if (preg_match('/^(?:\s*.\s*)?^('.
                    ($type == TXT_ING ? 'TXT\/ING' : ($type == LIR ? "LOADING INSTRUCTION\/REPORT" : $type))
                    .')/m', $emailBody)){

                    if (in_array($type, [PNL, ADL])){
                        $this->type = $type;
                    }
                    else {
                        $this->messageType = $type;
                    }

                }
            }
        }

    }

}
