<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


use App\Models\Airline;
use App\Models\Container;
use App\Models\ContainerType;
use App\Models\FlightContainer;
use App\Models\FlightContainerInfo;

class ParseUCM
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    function getParsingPattern($parseText){
        switch ($this->parseOperations->AIRLINE){
            case TAJIK_AIR:
                $pattern = '/^\s*UCM\s*^\s*([0-9A-Z]{2}[A-Z]?)(?:[0-9]{1,5}[A-Z]?)\/((?:[0-9]{1,5}[A-Z]?))?\.([0-9]{2})([A-Z]{3})?[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})?(?:\.([A-Z]{3}))\s*([\s\S]*(?=SI|ENDUCM|))/m';
//                $pattern = '/^\s*UCM\s*^\s*([0-9A-Z]{2}[A-Z]?)(?:[0-9]{1,5}[A-Z]?)\/((?:[0-9]{1,5}[A-Z]?))?\.([0-9]{2})([A-Z]{3})?[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})?(?:\.([A-Z]{3}))\s*(?:(IN[\s\S]*)(OUT[\s\S]*)(?=SI|ENDUCM|))/m';
                break;

            default:
                $pattern = '/^\s*UCM\s*^\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})([A-Z]{3})?[\.\s]*([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})?(?:\.([A-Z]{3}))\s*([\s\S]*(?=SI|ENDUCM))/m';
                break;
        }

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try){
            switch ($this->parseOperations->AIRLINE){
                case TAJIK_AIR:
                    list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $aircraftName, $departureAirport, $content) = $matches;

                    $messageDetails = [
                        "airline"           => $airline[0],
                        "flightNumber"      => $flightNumber[0],
                        "departureDay"      => $departureDay[0],
                        "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
                        "aircraftName"      => $aircraftName    ? $aircraftName[0]  : null,
                        "departureAirport"  => $departureAirport ? $departureAirport[0] : "",
                        "content"           => $content    ? $content[0]  : null,
                        // SKIP FOR NOW
//                        "INcontent"         => $INcontent    ? $INcontent[0]  : null,
                    ];

                    if ($messageDetails["airline"] == "TD"){
                        $messageDetails["airline"] = "7J";
                    }

                    return $messageDetails;

                default:
                    list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $aircraftName, $departureAirport, $content) = $matches;
                    $messageDetails = [
                        "airline"           => $airline[0],
                        "flightNumber"      => $flightNumber[0],
                        "departureDay"      => $departureDay[0],
                        "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
                        "aircraftName"      => $aircraftName    ? $aircraftName[0]  : null,
                        "departureAirport"  => $departureAirport ? $departureAirport[0] : "",
                        "content"           => $content    ? $content[0]  : null,
                    ];

                    return $messageDetails;

            }
        }

        return null;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        $messageDetails = $this->getParsingPattern($parseText);

        if ($messageDetails)
        {
            debug($messageDetails);

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails['departureMonth']);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if (!$messageDetails["content"]){
                return false;
            }

            // Get Details Info

            if ( $flight && !$partialParsing) {
                $readyData = [];

                $destinationAirportIATA = null;
                if ($flightNumber && $flightNumber->arrivalAirport && $flightNumber->arrivalAirport->iata) {
                    $destinationAirportIATA = $flightNumber->arrivalAirport->iata;
                }

                if (preg_match_all('/(?:(?:\.(\w+)+))/m', $messageDetails['content'], $contentMatches)) {
//                if (preg_match_all('/\.(.*?)(?=\.|ENDUCM|SI|\n)/m', $messageDetails['content'], $contentMatches)) {

                    // debug($contentMatches);

                    if (isset($contentMatches[1]) && $contentMatches[1] && count($contentMatches[1])) {

                        $flightContainerIds = [];

                        // Find record
                        $flightContainerInfo = FlightContainerInfo::whereNull("manual")
                            ->where("flight_id", $flight->id)
                            ->first();

                        // Create New
                        if (!$flightContainerInfo) {
                            $flightContainerInfo = new FlightContainerInfo();
                            $flightContainerInfo->flight_id = $flight->id;
                            $flightContainerInfo->save();
                        }

                        debug($contentMatches);
                        foreach ($contentMatches[1] as $each) {

                            $split = explode("-", $each);

                            foreach ($split as $row) {

                                if (preg_match_all('/(\w{3})(\d+)(\w{2})(?:\/(\w{3})\/(\w{1}))?/m', $row, $containerMatches)) {
                                    list($body, $containerTypeName, $containerNo, $owner, $destinationAirport, $loadedType) = $containerMatches;

                                    $containerDetails = [
                                        "containerTypeName" => $containerTypeName && $containerTypeName[0] ? $containerTypeName[0] : null,
                                        "containerNumber" => $containerNo && $containerNo[0] ? $containerNo[0] : null,
                                        "owner" => $owner && $owner[0] ? $owner[0] : null,
                                        "destinationAirport" => $destinationAirport && $destinationAirport[0] ? $destinationAirport[0] : null,
                                        "loadedType" => $loadedType[0] ? trim($loadedType[0]) : null,
                                    ];

                                    // debug($containerDetails);

                                    // Find Container Type
                                    $containerType = ContainerType::findByName($containerDetails);

                                    // Find Container
                                    $container = Container::find($containerType, $containerDetails, $airline, $this->parseOperations->airlineIDs, $this->parseOperations->airlineICAOIDs);

                                    // Insert To Flights List
                                    $flightContainerIds[] = FlightContainer::insertContainerToFlight(UCM, $flightContainerInfo, $containerType, $container, $containerDetails, $this->parseOperations->airportIDs);

                                    $readyData[] = $containerDetails;
                                }

                            }
                        }

                        // Remove not found flight containers
                        FlightContainer::where("info_id", $flightContainerInfo->id)
                            ->whereNotIn("id", $flightContainerIds)
                            ->whereNotNull("from_ucm")
                            ->delete();
                    }
                }

                // SI (Additional Info)
                // Needs to be saved somewhere so it could be shown in flight info
                if (preg_match('/SI\s*([\s\S]*)/m', $parseText, $siMatch)) {
                    $messageDetails["si"] = $siMatch[1];
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $message = $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    $message = Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            if (isset($flightContainerInfo) && $flightContainerInfo) {
                if (isset($messageDetails["si"]) && $messageDetails["si"]){
                    $flightContainerInfo->si = $messageDetails["si"];
                }
                if (isset($message) && $message){
                    $flightContainerInfo->message_ucm_id = $message->id;
                }
                $flightContainerInfo->save();
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;

    }


}
