<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseTPM
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        $pattern = '/^\s*(?:TPM)\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Z]{3})[\.\s])?(?:([A-Z0-9]{5})[\.\s])?(?:([A-Z]{3})\s)?[\.\s]*(?:(?!OUT)([A-Z]{3})[\.\s])?/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $aircraftName, $arrivalAirport) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureMonth"    => $departureMonth      ? $departureMonth[0]    : "",
                "aircraftName"      => $aircraftName        ? $aircraftName[0]      : null,
                "arrivalAirport"    => $arrivalAirport      ? $arrivalAirport[0]  : null,
            ];

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            if ($messageDetails["airline"] && in_array($messageDetails["airline"], ["EI", "3O", "8Q", "EL", "U6", "E5"])){
                $messageDetails["departureAirport"] = $messageDetails["arrivalAirport"];
                $messageDetails["arrivalAirport"] = null;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if (!$partialParsing) {
                $patternLine = '/^(?!(?:TPM|ENDPART|ENDTPM))\d*(.+)$/m';

                if (preg_match_all($patternLine, $parseText, $matchesLine)) {

                    $patternEach = '/^\d*(?:(INF)?\s*([A-Z]+)(?:\/((?:[A-Z\/]|\s(?:MR|MRS|MISS|CHD|MS|DR)|\s[A-Z])+))?)((?:\s*[A-Z]+)*?)(?:\s\d+INF\/(?:([A-Z]+)\/)?([A-Z]+\s*[A-Z]+))?/m';

                    $totalPax = [];

                    $parentPassengerFlight = null;
                    $infPsnDetails = $infProcessed = null;

                    foreach ($matchesLine[1] as $eachLine) {

                        if (contains($eachLine, ["PART"])) {
                            continue;
                        }

                        if (preg_match($patternEach, $eachLine, $matchesEach)) {

                            $inf = isset($matchesEach[1]) && $matchesEach[1] ? trim($matchesEach[1]) : null;
                            $lastName = isset($matchesEach[2]) && $matchesEach[2] ? trim($matchesEach[2]) : null;
                            $firstNamesString = isset($matchesEach[3]) && $matchesEach[3] ? trim($matchesEach[3]) : null;
                            $firstNamesOrTitle = isset($matchesEach[4]) && $matchesEach[4] ? trim($matchesEach[4]) : null;
                            $infLastName = isset($matchesEach[5]) && $matchesEach[5] ? trim($matchesEach[5]) : null;
                            $infFirstName = isset($matchesEach[6]) && $matchesEach[6] ? trim($matchesEach[6]) : null;


                            if (in_array($lastName, ["COR", "TPM", "END", "ENDTPM", "ENDPART"]) || contains($lastName, ["ENDTPM", "ENDPART"])) {
                                continue;
                            }

                            $firstNamesString = str_replace([" DR "], "", $firstNamesString);

                            $firstNamesString = str_replace([" ", "  ", "   "], "", $firstNamesString);

                            if ($infFirstName) {
                                $infPsnDetails = [
                                    "infLname" => $infLastName ? $infLastName : $lastName,
                                    "infFname" => $infFirstName,
                                ];
                            }

                            if ($firstNamesString) {

                                if (contains($firstNamesString, "/")) {
                                    $fNames = explode("/", $firstNamesString);

                                    $j = 0;
                                    foreach ($fNames as $fNameEach) {
                                        if ($fNameEach) {
                                            $j++;

                                            list($fName, $gen, $isChild, $isInf) = Parse::trimNameAndGetGender($fNameEach);

                                            $psnDetails = [
                                                "lastName"  => $lastName,
                                                "firstName" => $fName,
                                                "gender"    => $gen,
                                                "is_inf"    => $isInf,
                                                "is_chd"    => $isChild,
                                            ];

                                            if ($infPsnDetails && !$infProcessed && !$isInf && !$isChild) {
                                                $psnDetails["infLname"] = $infPsnDetails["infLname"];
                                                $psnDetails["infFname"] = $infPsnDetails["infFname"];
                                                $infProcessed = true;

                                                // Apply strict matching since we know these are different people with same Last names
                                                $parentPassengerFlight = Parse::findPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, TPM, true);

//                                            debug($parentPassengerFlight->passenger_id. " ".$parentPassengerFlight->passenger->last_name. " ".$parentPassengerFlight->passenger->first_name);
                                            }
                                            else
                                            {
                                                if ($lastName == "C" && !$fName){
                                                    continue;
                                                }

                                                // Apply strict matching since we know these are different people with same Last names
                                                $pf = Parse::findPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, TPM, true);

//                                            debug($pf->passenger_id. " ".$pf->passenger->last_name. " ".$pf->passenger->first_name);
                                            }

                                            $totalPax[] = $psnDetails;
                                        }
                                    }
                                } else {
                                    list($fName, $gen, $isChild, $isInf) = Parse::trimNameAndGetGender($firstNamesString);

                                    $fNames = explode(" ", $firstNamesOrTitle);

                                    foreach ($fNames as $each) {
                                        $item = trim($each);

                                        if (!$item) {
                                            continue;
                                        }

                                        if (in_array($item, [MR, MSTR])) {
                                            $gen = MALE;
                                        } else if (in_array($item, [MS, MRS, MISS])) {
                                            $gen = FEMALE;
                                        } else if (in_array($item, [INFT])) {
                                            $gen = null;
                                            $isInf = true;
                                        } else if (in_array($item, [CHD])) {
                                            $gen = null;
                                            $isChild = true;
                                        } else if (in_array($item, [DR])) {
                                            $gen = null;
                                        } else {
                                            $fName .= " " . $item;
                                        }
                                    }

                                    $fName = trim($fName);

                                    if ($isInf)
                                    {
                                        $psnDetails = [
                                            "infLname" => $lastName,
                                            "infFname" => $fName,
                                        ];

                                        $pf = Parse::findInfPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $parentPassengerFlight, TRUE, TPM);
//                                    debug($pf->passenger_id. " ".$pf->passenger->last_name. " ".$pf->passenger->first_name);
                                    }
                                    else
                                    {
                                        if ($lastName == "C" && !$fName){
                                            continue;
                                        }

                                        $psnDetails = [
                                            "lastName"  => $lastName,
                                            "firstName" => $fName,
                                            "gender"    => $gen,
                                        ];


                                        if ($infPsnDetails && !$infProcessed) {
                                            $psnDetails["infLname"] = $infPsnDetails["infLname"];
                                            $psnDetails["infFname"] = $infPsnDetails["infFname"];
                                        }

                                        $parentPassengerFlight = Parse::findPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, TPM);
//                                    debug($parentPassengerFlight->passenger_id. " ".$parentPassengerFlight->passenger->last_name. " ".$parentPassengerFlight->passenger->first_name);
                                    }

                                    $totalPax[] = $psnDetails;

                                }
                            } else {

                                $isInf = $inf == "INF";

                                if ($isInf) {
                                    $psnDetails = [
                                        "infLname" => $lastName
                                    ];

                                    $pf = Parse::findInfPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $parentPassengerFlight, TRUE, TPM);
//                                debug($pf->passenger_id. " ".$pf->passenger->last_name. " ".$pf->passenger->first_name);
                                }
                                else {
                                    if ($lastName == "C"){
                                        continue;
                                    }

                                    $psnDetails = [
                                        "lastName" => $lastName,
                                    ];

                                    $parentPassengerFlight = Parse::findPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, TPM);
//                                debug($parentPassengerFlight->passenger_id. " ".$parentPassengerFlight->passenger->last_name. " ".$parentPassengerFlight->passenger->first_name);
                                }

                                $totalPax[] = $psnDetails;

                            }
                        }

                    }
                    debug($totalPax);
                }
            }
            //return true;

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
