<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParseSLS
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null){

        $pattern = '/^\s*SLS\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})\.([A-Z0-9]{1,4}[-]?[A-Z0-9]{1,4})\.(\w+)[-\/](\d+)\.(\w{3})\.(\d{2})(\w{3})(\d{2})/m';

        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $aircraftName, $aircraftType, $capacityTotal,
                $departureAirport, $depDay, $departureMonth, $departureYear) = $matches;

            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "aircraftName"      => $aircraftName[0],
                "aircraftType"      => $aircraftType[0],
                "capacityTotal"     => $capacityTotal[0],
                "departureAirport"  => $departureAirport[0],
                "stationDetails"    => [],
//                "departureMonth"    => $departureMonth ? $departureMonth[0] : "",
//                "departureYear"     => $departureYear ? $departureYear[0] : "",
            ];


            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            $stationPattern = '/^-(.+)/m';

            if (preg_match_all($stationPattern, $parseText, $matchStations)){

                if (isset($matchStations[0])){

                    foreach ($matchStations[0] as $each) {

                        $stationPattern = '/^-(\w{3})(?:\.FF\/(\w+)(?:\/(\w+))?)?\.YY\/(?:(\d+)\/)?(\d+)\.GG\/(\d+)(?:.B\/(\d+))?(?:.C\/(\d+))?(?:.S\/(\d+))?(?:.M\/(\d+))?/m';

                        preg_match_all($stationPattern, $each, $stationEach);

                        list($data, $station, $ffC, $ffY, $paxC, $paxY, $paxNonRevenue, $baggage, $cargo, $s, $mail) = $stationEach;

                        $stationDetails = [
                            "station"           => $station[0],
                            "ffC"               => $ffC     ? $ffC[0]   : null,
                            "ffY"               => $ffY     ? $ffY[0]   : null,
                            "paxC"              => $paxC    ? $paxC[0]  : null,
                            "paxY"              => $paxY    ? $paxY[0]  : null,
                            "paxNonRevenue"     => $paxNonRevenue   ? $paxNonRevenue[0] : null,
                            "baggage"           => $baggage         ? $baggage[0]       : null,
                            "cargo"             => $cargo           ? $cargo[0]         : null,
                            "s"                 => $s               ? $s[0]             : null,
                            "mail"              => $mail            ? $mail[0]          : null,
                        ];

                        $messageDetails["stationDetails"][] = $stationDetails;
                    }
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }

        }

        return false;
    }
}
