<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 30.03.17

 */

namespace App\Classes\Parsing;


class ParsePTM
{
    public $parseOperations;

    public function __construct($parseOperations){
        $this->parseOperations = $parseOperations;
    }

    public function run($parseText, ParseEmail $parseEmail = null, $message = null, $partialParsing = null){

        $pattern = '/^\s*PTM\s*([0-9A-Z]{2}[A-Z]?)([0-9]{1,5}[A-Z]?)\/([0-9]{2})[\.\s]*(?:([0-9A-Za-z]{3})(?:[\.\s]))?([A-Za-z]{3})?[\.\s]*(?:([A-Za-z]{3})(?:[\.\s]))?/m';
        $try = preg_match_all($pattern, $parseText, $matches);

        if ($try)
        {
            list($emailBody, $airline, $flightNumber, $departureDay, $departureMonth, $departureAirport, $arrivalAirport) = $matches;
            $messageDetails = [
                "airline"           => $airline[0],
                "flightNumber"      => $flightNumber[0],
                "departureDay"      => $departureDay[0],
                "departureMonth"    => $departureMonth      ? $departureMonth[0]    : "",
                "departureAirport"  => $departureAirport    ? $departureAirport[0]  : "",
                "arrivalAirport"    => $arrivalAirport      ? $arrivalAirport[0]    : null,
            ];

            if (airlineModule()){
                $messageDetails["arrivalAirport"] = null;
            }

            // Get Month And Year Of Email Sent Date And Departure Date From Details
            $date = Parse::sentDateCheck($messageDetails["departureDay"], $this->parseOperations->sentDate, $parseEmail, $this->parseOperations->skipDateRangeCheck, $messageDetails["departureMonth"]);
            if (!$date){
                return false;
            }

            //**** Updated Find mechanism *****
            $findFlight = $this->parseOperations->parseHelper->findFlightProcess($messageDetails, $date, true, $parseEmail);

            if (!$findFlight || !Parse::isHandlingAirline($findFlight["airline"])){
                return null;
            }

            $flight = $findFlight["flight"];
            $aircraft = $findFlight["aircraft"];
            $airline = $findFlight["airline"];
            $flightNumber = $findFlight["flightNumber"];
            $codeShare = $findFlight["codeShare"];

            //**** Updated edit mechanism *****
            $this->parseOperations->parseHelper->updateFlightInformation($flight, $messageDetails, $aircraft, $date, $codeShare, $parseEmail);

            if (!$partialParsing) {
                // Get Details Info
                $ptmPattern = '/(?:([A-Z0-9]{2})([A-Z0-9]+)(?:\/(\d+))?\s*([A-Z0-9]{3})\s*(\d+)([A-Z]{1})\s*(\d+)B(?:(\d+)K)?\s*([A-Z]+[\-\s]?[A-Z]+)(?:\/(?:([A-Z]+(?=MRS|MR|MS|MISS|CHD)|[A-Z]+)(?:(MRS|MR|MS|MISS|CHD)?(.*))))?)/';
                if (preg_match_all($ptmPattern, $parseText, $ptmMatches)) {
                    list ($all, $depAirline, $depFlightNumber, $departureDay, $departureAirport, $passengersCount, $rbd, $baggageCount, $baggageKgs, $lastName, $firstName, $gender, $nameString) = $ptmMatches;

                    $nameString = str_replace(["\r"], "", $nameString);
                    $allPtmDetails = [];
                    foreach ($depAirline as $i => $each) {
                        $ptmDetails = [
                            "lastName" => $lastName[$i],
                            "firstName" => $firstName[$i],
                            "gender" => Parse::getGender($gender[$i]),

                            "outbAirline" => $depAirline[$i],
                            "outbFltNo" => $depFlightNumber[$i],
                            "outbDay" => $departureDay[$i] ? $departureDay[$i] : $messageDetails["departureDay"],
                            "outbDest" => $departureAirport[$i],
                            "outbRBD" => $rbd[$i],

                            "baggagePcs" => $baggageCount[$i],
                            "baggageWeight" => $baggageKgs[$i],
//                        "ptmNameStr"        => $nameString[$i],
                            "ptmPax" => $passengersCount[$i],
                        ];


                        if ($nameString[$i] && contains($nameString[$i], "/")) {

                            // First PAX
                            Parse::findPassengerProcess($ptmDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, PTM);

                            // Other PAX
                            $passengers = explode("/", $nameString[$i]);

                            foreach ($passengers as $person) {
                                if ($person) {
                                    $gen = null;
                                    $fName = $person;

                                    $psnDetails = [
                                        "lastName" => $ptmDetails['lastName'],
                                        "firstName" => $fName,
                                        "outbAirline" => $ptmDetails['outbAirline'],
                                        "outbFltNo" => $ptmDetails['outbFltNo'],
                                        "outbDay" => $ptmDetails['outbDay'],
                                        "outbDest" => $ptmDetails['outbDest'],
                                        "outbRBD" => $ptmDetails['outbRBD'],
                                    ];

                                    Parse::getPassengerGender($psnDetails);

                                    if ($psnDetails['firstName'] != "") {

                                        Parse::findPassengerProcess($psnDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, PTM);

                                        $allPtmDetails[] = $psnDetails;
                                    }

                                }
                            }
                        }
                        else {

                            $nameString[$i] = trim(str_replace(".", "", $nameString[$i]));

                            if (in_array($nameString[$i], [MR, MRS, MS, MISS, CHD])) {
                                // identify gender
                                $ptmDetails['gender'] = Parse::getGender($nameString[$i]);
                            } else if ($nameString[$i] == "" || contains($nameString[$i], CHD) || contains($nameString[$i], INF_USE)) {
                                // Do Nothing
                            } else {
                                // Concat to existing first name
                                $ptmDetails['firstName'] .= trim($nameString[$i]);
                            }

                            Parse::findPassengerProcess($ptmDetails, $flight, $this->parseOperations->sentDate, $this->parseOperations->countryIDs, $this->parseOperations->countryISOIDs, true, PTM);

                        }

                        $allPtmDetails[] = $ptmDetails;
                    }

                    debug($allPtmDetails);
                }
            }

            // Create Message
            if ($message){
                Parse::updateMessage($message, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
            }
            else {
                if ($parseEmail){
                    $parseEmail->createMessage($flight, $flightNumber, $messageDetails);
                }
                else {
                    Parse::createMessage($parseText, $this->parseOperations->messageType, $flight, $flightNumber, $messageDetails);
                }
            }

            return true;
        }
        else
        {
            // Create Message
            if ($parseEmail && !$message){
                $parseEmail->createMessage();
            }
        }

        return false;

    }

}
